/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text.regex;

import java.util.Hashtable;
import org.renjin.primitives.text.regex.REProgram;
import org.renjin.primitives.text.regex.RESyntaxException;

public class RECompiler {
    char[] instruction = new char[128];
    int lenInstruction = 0;
    String pattern;
    int len;
    int idx;
    int parens;
    static final int NODE_NORMAL = 0;
    static final int NODE_NULLABLE = 1;
    static final int NODE_TOPLEVEL = 2;
    static final int ESC_MASK = 1048560;
    static final int ESC_BACKREF = 1048575;
    static final int ESC_COMPLEX = 1048574;
    static final int ESC_CLASS = 1048573;
    static final int bracketUnbounded = -1;
    int bracketMin;
    int bracketOpt;
    static final Hashtable hashPOSIX = new Hashtable();

    void ensure(int n) {
        int curlen = this.instruction.length;
        if (this.lenInstruction + n >= curlen) {
            while (this.lenInstruction + n >= curlen) {
                curlen *= 2;
            }
            char[] newInstruction = new char[curlen];
            System.arraycopy(this.instruction, 0, newInstruction, 0, this.lenInstruction);
            this.instruction = newInstruction;
        }
    }

    void emit(char c2) {
        this.ensure(1);
        this.instruction[this.lenInstruction++] = c2;
    }

    void nodeInsert(char opcode, int opdata, int insertAt) {
        this.ensure(3);
        System.arraycopy(this.instruction, insertAt, this.instruction, insertAt + 3, this.lenInstruction - insertAt);
        this.instruction[insertAt] = opcode;
        this.instruction[insertAt + 1] = (char)opdata;
        this.instruction[insertAt + 2] = '\u0000';
        this.lenInstruction += 3;
    }

    void setNextOfEnd(int node, int pointTo) throws RESyntaxException {
        char next = this.instruction[node + 2];
        while (next != '\u0000' && node < this.lenInstruction) {
            if (node == pointTo) {
                pointTo = this.lenInstruction;
            }
            next = this.instruction[(node += next) + 2];
        }
        if (node < this.lenInstruction) {
            int offset = pointTo - node;
            if (offset != (short)offset) {
                throw new RESyntaxException("Exceeded short jump range.");
            }
            this.instruction[node + 2] = (char)offset;
        }
    }

    int node(char opcode, int opdata) {
        this.ensure(3);
        this.instruction[this.lenInstruction] = opcode;
        this.instruction[this.lenInstruction + 1] = (char)opdata;
        this.instruction[this.lenInstruction + 2] = '\u0000';
        this.lenInstruction += 3;
        return this.lenInstruction - 3;
    }

    void internalError() throws Error {
        throw new Error("Internal error!");
    }

    void syntaxError(String s) throws RESyntaxException {
        throw new RESyntaxException(s + " at char " + (this.idx + 1));
    }

    void bracket() throws RESyntaxException {
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '{') {
            this.internalError();
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        StringBuffer number = new StringBuffer();
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            number.append(this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketMin = Integer.parseInt(number.toString());
        }
        catch (NumberFormatException e) {
            this.syntaxError("Expected valid number");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            this.bracketOpt = 0;
            return;
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != ',') {
            this.syntaxError("Expected comma");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == '}') {
            ++this.idx;
            this.bracketOpt = -1;
            return;
        }
        if (this.idx >= this.len || !Character.isDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        number.setLength(0);
        while (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
            number.append(this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketOpt = Integer.parseInt(number.toString()) - this.bracketMin;
        }
        catch (NumberFormatException e) {
            this.syntaxError("Expected valid number");
        }
        if (this.bracketOpt < 0) {
            this.syntaxError("Bad range");
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != '}') {
            this.syntaxError("Missing close brace");
        }
    }

    int escape() throws RESyntaxException {
        if (this.pattern.charAt(this.idx) != '\\') {
            this.internalError();
        }
        if (this.idx + 1 == this.len) {
            this.syntaxError("Escape terminates string");
        }
        this.idx += 2;
        char escapeChar = this.pattern.charAt(this.idx - 1);
        switch (escapeChar) {
            case 'B': 
            case 'b': {
                return 1048574;
            }
            case 'D': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 's': 
            case 'w': {
                return 1048573;
            }
            case 'u': 
            case 'x': {
                int hexDigits = escapeChar == 'u' ? 4 : 2;
                int val = 0;
                while (this.idx < this.len && hexDigits-- > 0) {
                    char c2 = this.pattern.charAt(this.idx);
                    if (c2 >= '0' && c2 <= '9') {
                        val = (val << 4) + c2 - 48;
                    } else if ((c2 = Character.toLowerCase(c2)) >= 'a' && c2 <= 'f') {
                        val = (val << 4) + (c2 - 97) + 10;
                    } else {
                        this.syntaxError("Expected " + hexDigits + " hexadecimal digits after \\" + escapeChar);
                    }
                    ++this.idx;
                }
                return val;
            }
            case 't': {
                return 9;
            }
            case 'n': {
                return 10;
            }
            case 'r': {
                return 13;
            }
            case 'f': {
                return 12;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx)) || escapeChar == '0') {
                    int val = escapeChar - 48;
                    if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                        val = (val << 3) + (this.pattern.charAt(this.idx++) - 48);
                        if (this.idx < this.len && Character.isDigit(this.pattern.charAt(this.idx))) {
                            val = (val << 3) + (this.pattern.charAt(this.idx++) - 48);
                        }
                    }
                    return val;
                }
                return 1048575;
            }
        }
        return escapeChar;
    }

    int characterClass() throws RESyntaxException {
        int CHAR_INVALID;
        if (this.pattern.charAt(this.idx) != '[') {
            this.internalError();
        }
        if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) == ']') {
            this.syntaxError("Empty or unterminated class");
        }
        int ret = this.node('[', 0);
        int last = CHAR_INVALID = 65535;
        boolean include = true;
        boolean definingRange = false;
        int idxFirst = this.idx;
        int rangeStart = 0;
        RERange range2 = new RERange();
        block18: while (this.idx < this.len && this.pattern.charAt(this.idx) != ']') {
            int simpleChar;
            switch (this.pattern.charAt(this.idx)) {
                case '^': {
                    if (this.idx == idxFirst) {
                        range2.include(0, 65535, true);
                        include = !include;
                        ++this.idx;
                        continue block18;
                    }
                    simpleChar = 94;
                    ++this.idx;
                    break;
                }
                case '[': {
                    String className = this.posixClass();
                    if (className == null) {
                        simpleChar = 91;
                        ++this.idx;
                        break;
                    }
                    this.idx += className.length() + "[::]".length();
                    if (className.equals("alpha")) {
                        range2.include(65, 90, include);
                        range2.include(97, 122, include);
                        continue block18;
                    }
                    if (className.equals("alnum")) {
                        range2.include(65, 90, include);
                        range2.include(97, 122, include);
                        range2.include(48, 57, include);
                        continue block18;
                    }
                    if (className.equals("blank")) {
                        range2.include(' ', include);
                        range2.include('\t', include);
                        continue block18;
                    }
                    if (className.equals("digit")) {
                        range2.include(48, 57, include);
                        continue block18;
                    }
                    if (className.equals("upper")) {
                        range2.include(65, 90, include);
                        continue block18;
                    }
                    if (className.equals("lower")) {
                        range2.include(97, 122, include);
                        continue block18;
                    }
                    if (className.equals("space")) {
                        range2.include(' ', include);
                        range2.include('\t', include);
                        range2.include('\r', include);
                        range2.include('\n', include);
                        range2.include('\u000b', include);
                        range2.include('\f', include);
                        continue block18;
                    }
                    throw new RESyntaxException("Posix class " + className + " not implemented");
                }
                case '\\': {
                    int c2 = this.escape();
                    switch (c2) {
                        case 1048574: 
                        case 1048575: {
                            this.syntaxError("Bad character class");
                        }
                        case 1048573: {
                            if (definingRange) {
                                this.syntaxError("Bad character class");
                            }
                            switch (this.pattern.charAt(this.idx - 1)) {
                                case 'S': {
                                    range2.include(0, 7, include);
                                    range2.include('\u000b', include);
                                    range2.include(14, 31, include);
                                    range2.include(33, 65535, include);
                                    break;
                                }
                                case 'W': {
                                    range2.include(0, 47, include);
                                    range2.include(58, 64, include);
                                    range2.include(91, 94, include);
                                    range2.include('`', include);
                                    range2.include(123, 65535, include);
                                    break;
                                }
                                case 'D': {
                                    range2.include(0, 47, include);
                                    range2.include(58, 65535, include);
                                    break;
                                }
                                case 's': {
                                    range2.include('\t', include);
                                    range2.include('\r', include);
                                    range2.include('\f', include);
                                    range2.include('\n', include);
                                    range2.include('\b', include);
                                    range2.include(' ', include);
                                    break;
                                }
                                case 'w': {
                                    range2.include(97, 122, include);
                                    range2.include(65, 90, include);
                                    range2.include('_', include);
                                }
                                case 'd': {
                                    range2.include(48, 57, include);
                                }
                            }
                            last = CHAR_INVALID;
                            continue block18;
                        }
                    }
                    simpleChar = (char)c2;
                    break;
                }
                case '-': {
                    if (this.idx + 1 < this.len && this.pattern.charAt(++this.idx) == ']') {
                        simpleChar = 45;
                        break;
                    }
                    if (last == CHAR_INVALID) {
                        simpleChar = 45;
                        break;
                    }
                    if (definingRange) {
                        this.syntaxError("Bad class range");
                    }
                    definingRange = true;
                    rangeStart = last;
                    continue block18;
                }
                default: {
                    simpleChar = this.pattern.charAt(this.idx++);
                }
            }
            if (definingRange) {
                int rangeEnd = simpleChar;
                if (rangeStart >= rangeEnd) {
                    this.syntaxError("Bad character class");
                }
                range2.include(rangeStart, rangeEnd, include);
                last = CHAR_INVALID;
                definingRange = false;
                continue;
            }
            if (this.idx >= this.len || this.pattern.charAt(this.idx) != '-' || this.idx + 1 >= this.len || this.pattern.charAt(this.idx + 1) == ']') {
                range2.include((char)simpleChar, include);
            }
            last = simpleChar;
        }
        if (this.idx == this.len) {
            this.syntaxError("Unterminated character class");
        }
        ++this.idx;
        this.instruction[ret + 1] = (char)range2.num;
        for (int i = 0; i < range2.num; ++i) {
            this.emit((char)range2.minRange[i]);
            this.emit((char)range2.maxRange[i]);
        }
        return ret;
    }

    private String posixClass() {
        int idx = this.idx;
        if (idx + 1 < this.len && this.pattern.charAt(idx + 1) == ':') {
            int idxStart = idx += 2;
            while (idx < this.len && this.pattern.charAt(idx) >= 'a' && this.pattern.charAt(idx) <= 'z') {
                ++idx;
            }
            if (idx + 1 < this.len && this.pattern.charAt(idx) == ':' && this.pattern.charAt(idx + 1) == ']') {
                String charClass = this.pattern.substring(idxStart, idx);
                idx += 2;
                return charClass;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    int atom() throws RESyntaxException {
        ret = this.node('A', 0);
        lenAtom = 0;
        block8: while (this.idx < this.len) {
            if (this.idx + 1 >= this.len) ** GOTO lbl-1000
            c = this.pattern.charAt(this.idx + 1);
            if (this.pattern.charAt(this.idx) == '\\') {
                idxEscape = this.idx;
                this.escape();
                if (this.idx < this.len) {
                    c = this.pattern.charAt(this.idx);
                }
                this.idx = idxEscape;
            }
            switch (c) {
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    if (lenAtom != 0) break block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (this.pattern.charAt(this.idx)) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '.': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '|': {
                            break block8;
                        }
                        case '*': 
                        case '+': 
                        case '?': 
                        case '{': {
                            if (lenAtom != 0) break block8;
                            this.syntaxError("Missing operand to closure");
                            break block8;
                        }
                        case '\\': {
                            idxBeforeEscape = this.idx;
                            c = this.escape();
                            if ((c & 1048560) == 1048560) {
                                this.idx = idxBeforeEscape;
                                break block8;
                            }
                            this.emit((char)c);
                            ++lenAtom;
                            continue block8;
                        }
                        default: {
                            this.emit(this.pattern.charAt(this.idx++));
                            ++lenAtom;
                            continue block8;
                        }
                    }
                }
            }
        }
        if (lenAtom == 0) {
            this.internalError();
        }
        this.instruction[ret + 1] = (char)lenAtom;
        return ret;
    }

    int terminal(int[] flags) throws RESyntaxException {
        switch (this.pattern.charAt(this.idx)) {
            case '$': 
            case '.': 
            case '^': {
                return this.node(this.pattern.charAt(this.idx++), 0);
            }
            case '[': {
                return this.characterClass();
            }
            case '(': {
                return this.expr(flags);
            }
            case ')': {
                this.syntaxError("Unexpected close paren");
            }
            case '|': {
                this.internalError();
            }
            case ']': {
                this.syntaxError("Mismatched class");
            }
            case '\u0000': {
                this.syntaxError("Unexpected end of input");
            }
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                this.syntaxError("Missing operand to closure");
            }
            case '\\': {
                int idxBeforeEscape = this.idx;
                switch (this.escape()) {
                    case 1048573: 
                    case 1048574: {
                        flags[0] = flags[0] & 0xFFFFFFFE;
                        return this.node('\\', this.pattern.charAt(this.idx - 1));
                    }
                    case 1048575: {
                        char backreference = (char)(this.pattern.charAt(this.idx - 1) - 48);
                        if (this.parens <= backreference) {
                            this.syntaxError("Bad backreference");
                        }
                        flags[0] = flags[0] | 1;
                        return this.node('#', backreference);
                    }
                }
                this.idx = idxBeforeEscape;
                flags[0] = flags[0] & 0xFFFFFFFE;
            }
        }
        flags[0] = flags[0] & 0xFFFFFFFE;
        return this.atom();
    }

    int closure(int[] flags) throws RESyntaxException {
        int n;
        int idxBeforeTerminal = this.idx;
        int[] terminalFlags = new int[]{0};
        int ret = this.terminal(terminalFlags);
        flags[0] = flags[0] | terminalFlags[0];
        if (this.idx >= this.len) {
            return ret;
        }
        boolean greedy = true;
        char closureType = this.pattern.charAt(this.idx);
        switch (closureType) {
            case '*': 
            case '?': {
                flags[0] = flags[0] | 1;
            }
            case '+': {
                ++this.idx;
            }
            case '{': {
                char opcode = this.instruction[ret];
                if (opcode == '^' || opcode == '$') {
                    this.syntaxError("Bad closure operand");
                }
                if ((terminalFlags[0] & 1) == 0) break;
                this.syntaxError("Closure operand can't be nullable");
            }
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == '?') {
            ++this.idx;
            greedy = false;
        }
        if (greedy) {
            switch (closureType) {
                case '{': {
                    this.bracket();
                    int bracketEnd = this.idx;
                    int bracketMin = this.bracketMin;
                    int bracketOpt = this.bracketOpt;
                    int pos = ret;
                    for (int c2 = 0; c2 < bracketMin; ++c2) {
                        this.idx = idxBeforeTerminal;
                        int n2 = pos;
                        pos = this.terminal(terminalFlags);
                        this.setNextOfEnd(n2, pos);
                    }
                    if (bracketOpt == -1) {
                        this.idx = bracketEnd;
                        this.nodeInsert('*', 0, pos);
                        this.setNextOfEnd(pos + 3, pos);
                        break;
                    }
                    if (bracketOpt > 0) {
                        int[] opt = new int[bracketOpt + 1];
                        this.nodeInsert('?', 0, pos);
                        opt[0] = pos;
                        for (int c3 = 1; c3 < bracketOpt; ++c3) {
                            opt[c3] = this.node('?', 0);
                            this.idx = idxBeforeTerminal;
                            this.terminal(terminalFlags);
                        }
                        int end = opt[bracketOpt] = this.node('N', 0);
                        for (int c4 = 0; c4 < bracketOpt; ++c4) {
                            this.setNextOfEnd(opt[c4], end);
                            this.setNextOfEnd(opt[c4] + 3, opt[c4 + 1]);
                        }
                    } else {
                        this.lenInstruction = pos;
                        this.node('N', 0);
                    }
                    this.idx = bracketEnd;
                    break;
                }
                case '?': {
                    this.nodeInsert('?', 0, ret);
                    n = this.node('N', 0);
                    this.setNextOfEnd(ret, n);
                    this.setNextOfEnd(ret + 3, n);
                    break;
                }
                case '*': {
                    this.nodeInsert('*', 0, ret);
                    this.setNextOfEnd(ret + 3, ret);
                    break;
                }
                case '+': {
                    this.nodeInsert('C', 0, ret);
                    n = this.node('+', 0);
                    this.setNextOfEnd(ret + 3, n);
                    this.setNextOfEnd(n, ret);
                    break;
                }
            }
        } else {
            switch (closureType) {
                case '?': {
                    this.nodeInsert('/', 0, ret);
                    n = this.node('N', 0);
                    this.setNextOfEnd(ret, n);
                    this.setNextOfEnd(ret + 3, n);
                    break;
                }
                case '*': {
                    this.nodeInsert('8', 0, ret);
                    this.setNextOfEnd(ret + 3, ret);
                    break;
                }
                case '+': {
                    this.nodeInsert('C', 0, ret);
                    n = this.node('=', 0);
                    this.setNextOfEnd(n, ret);
                    this.setNextOfEnd(ret + 3, n);
                    break;
                }
            }
        }
        return ret;
    }

    int branch(int[] flags) throws RESyntaxException {
        int ret = -1;
        int chain = -1;
        int[] closureFlags = new int[1];
        boolean nullable = true;
        while (this.idx < this.len && this.pattern.charAt(this.idx) != '|' && this.pattern.charAt(this.idx) != ')') {
            closureFlags[0] = 0;
            int node = this.closure(closureFlags);
            if (closureFlags[0] == 0) {
                nullable = false;
            }
            if (chain != -1) {
                this.setNextOfEnd(chain, node);
            }
            chain = node;
            if (ret != -1) continue;
            ret = node;
        }
        if (ret == -1) {
            ret = this.node('N', 0);
        }
        if (nullable) {
            flags[0] = flags[0] | 1;
        }
        return ret;
    }

    int expr(int[] flags) throws RESyntaxException {
        int currentNode;
        int end;
        int paren = -1;
        int ret = -1;
        int closeParens = this.parens;
        if ((flags[0] & 2) == 0 && this.pattern.charAt(this.idx) == '(') {
            if (this.idx + 2 < this.len && this.pattern.charAt(this.idx + 1) == '?' && this.pattern.charAt(this.idx + 2) == ':') {
                paren = 2;
                this.idx += 3;
                ret = this.node('<', 0);
            } else {
                if (this.idx + 2 < this.len && this.pattern.charAt(this.idx + 1) == '?') {
                    char next;
                    char qualifier = this.pattern.charAt(this.idx + 2);
                    if (qualifier == '=' || qualifier == '!') {
                        throw new RESyntaxException("Look-ahead assertions are not implemented");
                    }
                    if (qualifier == '<' && this.idx + 3 < this.len && ((next = this.pattern.charAt(this.idx + 3)) == '=' || next == '!')) {
                        throw new RESyntaxException("Look-behind assertions are not implemented");
                    }
                }
                paren = 1;
                ++this.idx;
                ret = this.node('(', this.parens++);
            }
        }
        flags[0] = flags[0] & 0xFFFFFFFD;
        boolean open2 = false;
        int branch = this.branch(flags);
        if (ret == -1) {
            ret = branch;
        } else {
            this.setNextOfEnd(ret, branch);
        }
        while (this.idx < this.len && this.pattern.charAt(this.idx) == '|') {
            if (!open2) {
                this.nodeInsert('|', 0, branch);
                open2 = true;
            }
            ++this.idx;
            int n = branch;
            branch = this.node('|', 0);
            this.setNextOfEnd(n, branch);
            this.branch(flags);
        }
        if (paren > 0) {
            if (this.idx < this.len && this.pattern.charAt(this.idx) == ')') {
                ++this.idx;
            } else {
                this.syntaxError("Missing close paren");
            }
            end = paren == 1 ? this.node(')', closeParens) : this.node('>', 0);
        } else {
            end = this.node('E', 0);
        }
        this.setNextOfEnd(ret, end);
        char nextNodeOffset = this.instruction[currentNode + 2];
        for (currentNode = ret; nextNodeOffset != '\u0000' && currentNode < this.lenInstruction; currentNode += nextNodeOffset) {
            if (this.instruction[currentNode] == '|') {
                this.setNextOfEnd(currentNode + 3, end);
            }
            nextNodeOffset = this.instruction[currentNode + 2];
        }
        return ret;
    }

    public REProgram compile(String pattern) throws RESyntaxException {
        this.pattern = pattern;
        this.len = pattern.length();
        this.idx = 0;
        this.lenInstruction = 0;
        this.parens = 1;
        int[] flags = new int[]{2};
        this.expr(flags);
        if (this.idx != this.len) {
            if (pattern.charAt(this.idx) == ')') {
                this.syntaxError("Unmatched close paren");
            }
            this.syntaxError("Unexpected input remains");
        }
        char[] ins = new char[this.lenInstruction];
        System.arraycopy(this.instruction, 0, ins, 0, this.lenInstruction);
        return new REProgram(this.parens, ins);
    }

    static {
        hashPOSIX.put("alnum", new Character('w'));
        hashPOSIX.put("alpha", new Character('a'));
        hashPOSIX.put("blank", new Character('b'));
        hashPOSIX.put("cntrl", new Character('c'));
        hashPOSIX.put("digit", new Character('d'));
        hashPOSIX.put("graph", new Character('g'));
        hashPOSIX.put("lower", new Character('l'));
        hashPOSIX.put("print", new Character('p'));
        hashPOSIX.put("punct", new Character('!'));
        hashPOSIX.put("space", new Character('s'));
        hashPOSIX.put("upper", new Character('u'));
        hashPOSIX.put("xdigit", new Character('x'));
        hashPOSIX.put("javastart", new Character('j'));
        hashPOSIX.put("javapart", new Character('k'));
    }

    class RERange {
        int size = 16;
        int[] minRange = new int[this.size];
        int[] maxRange = new int[this.size];
        int num = 0;

        RERange() {
        }

        void delete(int index) {
            if (this.num == 0 || index >= this.num) {
                return;
            }
            while (++index < this.num) {
                if (index - 1 < 0) continue;
                this.minRange[index - 1] = this.minRange[index];
                this.maxRange[index - 1] = this.maxRange[index];
            }
            --this.num;
        }

        void merge(int min2, int max2) {
            for (int i = 0; i < this.num; ++i) {
                if (min2 >= this.minRange[i] && max2 <= this.maxRange[i]) {
                    return;
                }
                if (min2 <= this.minRange[i] && max2 >= this.maxRange[i]) {
                    this.delete(i);
                    this.merge(min2, max2);
                    return;
                }
                if (min2 >= this.minRange[i] && min2 <= this.maxRange[i]) {
                    min2 = this.minRange[i];
                    this.delete(i);
                    this.merge(min2, max2);
                    return;
                }
                if (max2 < this.minRange[i] || max2 > this.maxRange[i]) continue;
                max2 = this.maxRange[i];
                this.delete(i);
                this.merge(min2, max2);
                return;
            }
            if (this.num >= this.size) {
                this.size *= 2;
                int[] newMin = new int[this.size];
                int[] newMax = new int[this.size];
                System.arraycopy(this.minRange, 0, newMin, 0, this.num);
                System.arraycopy(this.maxRange, 0, newMax, 0, this.num);
                this.minRange = newMin;
                this.maxRange = newMax;
            }
            this.minRange[this.num] = min2;
            this.maxRange[this.num] = max2;
            ++this.num;
        }

        void remove(int min2, int max2) {
            for (int i = 0; i < this.num; ++i) {
                if (this.minRange[i] >= min2 && this.maxRange[i] <= max2) {
                    this.delete(i);
                    return;
                }
                if (min2 >= this.minRange[i] && max2 <= this.maxRange[i]) {
                    int minr = this.minRange[i];
                    int maxr = this.maxRange[i];
                    this.delete(i);
                    if (minr < min2) {
                        this.merge(minr, min2 - 1);
                    }
                    if (max2 < maxr) {
                        this.merge(max2 + 1, maxr);
                    }
                    return;
                }
                if (this.minRange[i] >= min2 && this.minRange[i] <= max2) {
                    this.minRange[i] = max2 + 1;
                    return;
                }
                if (this.maxRange[i] < min2 || this.maxRange[i] > max2) continue;
                this.maxRange[i] = min2 - 1;
                return;
            }
        }

        void include(int min2, int max2, boolean include) {
            if (include) {
                this.merge(min2, max2);
            } else {
                this.remove(min2, max2);
            }
        }

        void include(char minmax, boolean include) {
            this.include(minmax, minmax, include);
        }
    }
}

