/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import java.util.concurrent.TimeUnit;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.renjin.eval.EvalException;
import org.renjin.primitives.time.Time;
import org.renjin.primitives.time.TimeVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class PosixLtVector
extends TimeVector {
    public static final String DST_FIELD = "isdst";
    public static final String DAY_OF_YEAR_FIELD = "yday";
    public static final String WEEKDAY_FIELD = "wday";
    public static final String YEAR_FIELD = "year";
    public static final String MONTH_FIELD = "mon";
    public static final String DAY_OF_MONTH_FIELD = "mday";
    public static final String HOUR_FIELD = "hour";
    public static final String MINUTE_FIELD = "min";
    public static final String SECOND_FIELD = "sec";
    public static final String GMT_OFFSET_FIELD = "gmtoff";
    public static final String ZONE_FIELD = "zone";
    private final ListVector vector;
    private final AtomicVector seconds;
    private final AtomicVector minutes;
    private final AtomicVector hours;
    private final AtomicVector daysOfMonth;
    private final AtomicVector monthsOfYear;
    private final AtomicVector years;
    private final DateTimeZone timeZone;
    private int length;

    public PosixLtVector(ListVector x) {
        this.vector = x;
        this.seconds = this.getElementAsVector(x, SECOND_FIELD);
        this.minutes = this.getElementAsVector(x, MINUTE_FIELD);
        this.hours = this.getElementAsVector(x, HOUR_FIELD);
        this.monthsOfYear = this.getElementAsVector(x, MONTH_FIELD);
        this.daysOfMonth = this.getElementAsVector(x, DAY_OF_MONTH_FIELD);
        this.years = this.getElementAsVector(x, YEAR_FIELD);
        Vector tzoneAttribute = (Vector)this.vector.getAttribute(Symbols.TZONE);
        this.timeZone = tzoneAttribute.length() >= 1 ? Time.timeZoneFromRSpecification(tzoneAttribute.getElementAsString(0)) : DateTimeZone.getDefault();
        this.length = this.maxLength(this.seconds, this.minutes, this.hours, this.monthsOfYear, this.daysOfMonth, this.years);
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    private int maxLength(AtomicVector ... components) {
        int maxLength = 0;
        for (AtomicVector component : components) {
            if (component.length() <= maxLength) continue;
            maxLength = component.length();
        }
        return maxLength;
    }

    private AtomicVector getElementAsVector(ListVector x, String fieldName) {
        SEXP sexp2 = this.vector.getElementAsSEXP(x.getIndexByName(fieldName));
        if (!(sexp2 instanceof IntVector) && !(sexp2 instanceof DoubleVector)) {
            throw new EvalException("Expected element '%s' to be of type integer or numeric, was %s", fieldName, sexp2.getTypeName());
        }
        return (AtomicVector)sexp2;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public DateTime getElementAsDateTime(int index) {
        int year = this.elementAt(this.years, index);
        if (IntVector.isNA(year)) {
            return null;
        }
        Chronology chronology = ISOChronology.getInstance().withZone(this.timeZone);
        long time2 = chronology.getDateTimeMillis(1900 + year, 1, 1, 0);
        int month = this.elementAt(this.monthsOfYear, index);
        if (IntVector.isNA(month)) {
            return null;
        }
        time2 = chronology.monthOfYear().add(time2, month);
        int dayOfMonth = this.elementAt(this.daysOfMonth, index);
        if (IntVector.isNA(dayOfMonth)) {
            return null;
        }
        int daysToAdd = dayOfMonth - 1;
        time2 = chronology.dayOfMonth().add(time2, daysToAdd);
        int hourOfDay = this.elementAt(this.hours, index);
        int minuteOfHour = this.elementAt(this.minutes, index);
        int secondOfMinute = this.elementAt(this.seconds, index);
        if (IntVector.isNA(hourOfDay) || IntVector.isNA(minuteOfHour) || IntVector.isNA(secondOfMinute)) {
            return null;
        }
        time2 = chronology.hourOfDay().add(time2, hourOfDay);
        time2 = chronology.minuteOfHour().add(time2, minuteOfHour);
        time2 = chronology.secondOfMinute().add(time2, secondOfMinute);
        return new DateTime(time2, chronology);
    }

    private int elementAt(AtomicVector component, int index) {
        return component.getElementAsInt(index % component.length());
    }

    public static class Builder {
        private ListVector.NamedBuilder list = new ListVector.NamedBuilder(0, 9);
        private IntArrayVector.Builder second = new IntArrayVector.Builder();
        private IntArrayVector.Builder minute = new IntArrayVector.Builder();
        private IntArrayVector.Builder hour = new IntArrayVector.Builder();
        private IntArrayVector.Builder dayOfMonth = new IntArrayVector.Builder();
        private IntArrayVector.Builder month = new IntArrayVector.Builder();
        private IntArrayVector.Builder year = new IntArrayVector.Builder();
        private IntArrayVector.Builder weekday = new IntArrayVector.Builder();
        private IntArrayVector.Builder dayOfYear = new IntArrayVector.Builder();
        private IntArrayVector.Builder dst = new IntArrayVector.Builder();
        private IntArrayVector.Builder gmtOffset = new IntArrayVector.Builder();
        private DateTimeZone zone;
        private StringVector zoneName;

        public Builder add(DateTime time2) {
            this.second.add(time2.getSecondOfMinute());
            this.minute.add(time2.getMinuteOfHour());
            this.hour.add(time2.getHourOfDay());
            this.dayOfMonth.add(time2.getDayOfMonth());
            this.month.add(time2.getMonthOfYear() - 1);
            this.year.add(time2.getYear() - 1900);
            this.weekday.add(Builder.getRDayOfWeek(time2));
            this.dayOfYear.add(time2.getDayOfYear() - 1);
            this.dst.add(Builder.computeDaylightSavingsFlag(time2));
            this.gmtOffset.add(this.computeGmtOffset(time2));
            return this;
        }

        public Builder addAll(Iterable<DateTime> dateTimes) {
            for (DateTime dateTime : dateTimes) {
                this.add(dateTime);
            }
            return this;
        }

        public Builder addNA() {
            this.second.addNA();
            this.minute.addNA();
            this.hour.addNA();
            this.dayOfMonth.addNA();
            this.month.addNA();
            this.year.addNA();
            this.weekday.addNA();
            this.dayOfYear.addNA();
            this.dst.add(-1);
            this.gmtOffset.addNA();
            return this;
        }

        public void withTimeZone(DateTimeZone zone, String zoneName) {
            this.zone = zone;
            this.zoneName = StringVector.valueOf(zoneName);
        }

        public Builder withTimeZone(SEXP timeZoneAttribute) {
            this.zone = Time.timeZoneFromTzoneAttribute(timeZoneAttribute);
            this.zoneName = timeZoneAttribute instanceof StringVector ? (StringVector)timeZoneAttribute : StringVector.valueOf(this.zone.getID());
            return this;
        }

        private static int computeDaylightSavingsFlag(DateTime time2) {
            if (time2 == null) {
                return -1;
            }
            return time2.getZone().isStandardOffset(time2.getMillis()) ? 0 : 1;
        }

        private int computeGmtOffset(DateTime time2) {
            return (int)TimeUnit.MILLISECONDS.toSeconds(time2.getZone().getOffset(time2));
        }

        private static int getRDayOfWeek(DateTime time2) {
            if (time2.getDayOfWeek() == 7) {
                return 0;
            }
            return time2.getDayOfWeek();
        }

        public ListVector buildListVector() {
            this.list.add(PosixLtVector.SECOND_FIELD, this.second);
            this.list.add(PosixLtVector.MINUTE_FIELD, this.minute);
            this.list.add(PosixLtVector.HOUR_FIELD, this.hour);
            this.list.add(PosixLtVector.DAY_OF_MONTH_FIELD, this.dayOfMonth);
            this.list.add(PosixLtVector.MONTH_FIELD, this.month);
            this.list.add(PosixLtVector.YEAR_FIELD, this.year);
            this.list.add(PosixLtVector.WEEKDAY_FIELD, this.weekday);
            this.list.add(PosixLtVector.DAY_OF_YEAR_FIELD, this.dayOfYear);
            this.list.add(PosixLtVector.DST_FIELD, this.dst);
            this.list.add(PosixLtVector.GMT_OFFSET_FIELD, this.gmtOffset);
            if (this.zone != null) {
                this.list.setAttribute(Symbols.TZONE, (SEXP)this.zoneName);
            }
            this.list.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector("POSIXlt", "POSIXt"));
            return this.list.build();
        }
    }
}

