/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.renjin.base.BaseFrame;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.base.Predicate;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.HasNamedValues;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.Recursive;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Environment
extends AbstractSEXP
implements Recursive,
HasNamedValues {
    public static final String TYPE_NAME = "environment";
    private static final String GLOBAL_ENVIRONMENT_NAME = "R_GlobalEnv";
    private String name = null;
    private Environment parent;
    protected Frame frame;
    private boolean locked;
    private Set<Symbol> lockedBindings;
    private transient int modCount = 0;
    public static final EmptyEnv EMPTY = new EmptyEnv();

    public static Environment createGlobalEnvironment(Environment baseEnvironment) {
        Environment global = new Environment();
        global.name = GLOBAL_ENVIRONMENT_NAME;
        global.parent = baseEnvironment;
        global.frame = new HashFrame();
        return global;
    }

    public static Environment createBaseEnvironment() {
        Environment base = new Environment();
        base.name = "base";
        base.parent = EMPTY;
        base.frame = new BaseFrame();
        return base;
    }

    public static Environment createChildEnvironment(Environment parent2) {
        return Environment.createChildEnvironment(parent2, new HashFrame());
    }

    public static Environment createNamespaceEnvironment(Environment parent2, String namespaceName) {
        Environment ns = Environment.createChildEnvironment(parent2);
        ns.name = "namespace:" + namespaceName;
        return ns;
    }

    public static Environment createNamedEnvironment(Environment parent2, String name) {
        Environment ns = Environment.createChildEnvironment(parent2);
        ns.name = name;
        return ns;
    }

    public static Environment createBaseNamespaceEnvironment(Environment globalEnv, Environment baseEnvironment) {
        Environment ns = Environment.createChildEnvironment(globalEnv, baseEnvironment.getFrame());
        ns.name = "namespace:base";
        return ns;
    }

    public static Environment createChildEnvironment(Environment parent2, Frame frame2) {
        Environment child = new Environment();
        child.parent = parent2;
        child.frame = frame2;
        return child;
    }

    public Environment() {
    }

    public Environment(AttributeMap attributes2) {
        super(attributes2);
    }

    public void setVariables(PairList pairList) {
        for (PairList.Node node : pairList.nodes()) {
            if (!node.hasTag()) {
                throw new IllegalArgumentException("All elements of pairList must be tagged");
            }
            this.setVariable(node.getTag(), node.getValue());
        }
    }

    public void remove(Symbol symbol2) {
        this.frame.remove(symbol2);
    }

    public void clear() {
        this.frame.clear();
    }

    public String getName() {
        SEXP nameAttribute = this.attributes.get(Symbols.NAME);
        if (nameAttribute instanceof StringVector) {
            return ((StringVector)nameAttribute).getElementAsString(0);
        }
        if (this.name == null) {
            return Integer.toString(this.hashCode());
        }
        return this.name;
    }

    public Environment getParent() {
        return this.parent;
    }

    public void setParent(Environment parent2) {
        this.parent = parent2;
        ++this.modCount;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public Collection<Symbol> getSymbolNames() {
        ArrayList<Symbol> ordered = new ArrayList<Symbol>(this.frame.getSymbols());
        Collections.sort(ordered, new Comparator<Symbol>(){

            @Override
            public int compare(Symbol o1, Symbol o2) {
                if (o1.getPrintName().startsWith(".") && !o2.getPrintName().startsWith(".")) {
                    return 1;
                }
                if (!o1.getPrintName().startsWith(".") && o2.getPrintName().startsWith(".")) {
                    return -1;
                }
                return o1.getPrintName().compareTo(o2.getPrintName());
            }
        });
        return ordered;
    }

    @Override
    public StringVector getNames() {
        StringVector.Builder names2 = new StringVector.Builder();
        for (Symbol name : this.getSymbolNames()) {
            names2.add(name.getPrintName());
        }
        return names2.build();
    }

    public boolean bindingIsLocked(Symbol symbol2) {
        return this.lockedBindings != null && this.lockedBindings.contains(symbol2);
    }

    public void setVariable(String name, SEXP value) {
        if (StringVector.isNA(name)) {
            name = "NA";
        }
        this.setVariable(Symbol.get(name), value);
    }

    public void setVariable(Symbol symbol2, SEXP value) {
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("Unbound: " + symbol2, new Object[0]);
        }
        if (this.bindingIsLocked(symbol2)) {
            throw new EvalException("cannot change value of locked binding for '%s'", symbol2.getPrintName());
        }
        if (this.locked && this.frame.getVariable(symbol2) != Symbol.UNBOUND_VALUE) {
            throw new EvalException("cannot add bindings to a locked environment", new Object[0]);
        }
        this.frame.setVariable(symbol2, value);
        ++this.modCount;
    }

    public SEXP findVariable(Context context, Symbol symbol2, Predicate<SEXP> predicate, boolean inherits2) {
        SEXP value = this.frame.getVariable(symbol2);
        if (value != Symbol.UNBOUND_VALUE) {
            if (value instanceof Promise) {
                value = value.force(context);
            }
            if (predicate.apply(value)) {
                return value;
            }
        }
        if (inherits2) {
            return this.parent.findVariable(context, symbol2, predicate, inherits2);
        }
        return Symbol.UNBOUND_VALUE;
    }

    public SEXP findVariable(Symbol symbol2) {
        if (symbol2.isVarArgReference()) {
            return this.findVarArg(symbol2.getVarArgReferenceIndex());
        }
        SEXP value = this.frame.getVariable(symbol2);
        if (value != Symbol.UNBOUND_VALUE) {
            return value;
        }
        return this.parent.findVariable(symbol2);
    }

    private SEXP findVarArg(int varArgReferenceIndex) {
        SEXP ellipses = this.findVariable(Symbols.ELLIPSES);
        if (ellipses == Symbol.UNBOUND_VALUE) {
            throw new EvalException("..%d used in an incorrect context, no ... to look in", varArgReferenceIndex);
        }
        PairList varArgs = (PairList)ellipses;
        if (varArgs.length() < varArgReferenceIndex) {
            throw new EvalException("The ... list does not contain %d items", varArgReferenceIndex);
        }
        return varArgs.getElementAsSEXP(varArgReferenceIndex - 1);
    }

    public SEXP findVariableOrThrow(Symbol name) {
        SEXP value = this.findVariable(name);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("object '" + name.getPrintName() + "' not found", new Object[0]);
        }
        return value;
    }

    public SEXP findVariableOrThrow(String name) {
        return this.findVariableOrThrow(Symbol.get(name));
    }

    public Function findFunction(Context context, Symbol symbol2) {
        if (this.frame.isMissingArgument(symbol2)) {
            throw new EvalException("argument '%s' is missing, with no default", symbol2.toString());
        }
        Function value = this.frame.getFunction(context, symbol2);
        if (value != null) {
            return value;
        }
        return this.parent.findFunction(context, symbol2);
    }

    public Function findFunctionOrThrow(Context context, Symbol symbol2) {
        Function function2 = this.findFunction(context, symbol2);
        if (function2 == null) {
            throw new EvalException("could not find function \"" + symbol2 + "\"", new Object[0]);
        }
        return function2;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getCumulativeModCount() {
        return this.modCount + this.parent.getCumulativeModCount();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void lock(boolean lockBindings) {
        this.locked = true;
        if (lockBindings) {
            this.lockedBindings = Sets.newHashSet(this.frame.getSymbols());
        }
    }

    public void lockBinding(Symbol symbol2) {
        if (this.frame.getVariable(symbol2) == Symbol.UNBOUND_VALUE) {
            throw new EvalException("no binding for '%s'", symbol2);
        }
        if (this.lockedBindings == null) {
            this.lockedBindings = Sets.newHashSet();
        }
        this.lockedBindings.add(symbol2);
    }

    public void unlockBinding(Symbol symbol2) {
        if (this.frame.getVariable(symbol2) == Symbol.UNBOUND_VALUE) {
            throw new EvalException("no binding for '%s'", symbol2);
        }
        if (this.lockedBindings != null) {
            this.lockedBindings.remove(symbol2);
        }
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    public Iterable<Environment> parents() {
        return new Iterable<Environment>(){

            @Override
            public Iterator<Environment> iterator() {
                return new EnvIterator(Environment.this.getParent());
            }
        };
    }

    public SEXP getVariable(Symbol symbol2) {
        return this.frame.getVariable(symbol2);
    }

    public SEXP getVariable(String symbolName) {
        return this.getVariable(Symbol.get(symbolName));
    }

    public SEXP getVariableByPrefix(String prefix) {
        Object value = null;
        if (this.frame.getSymbols().contains(Symbol.get(prefix))) {
            return this.frame.getVariable(Symbol.get(prefix));
        }
        for (Symbol name : this.frame.getSymbols()) {
            if (!name.getPrintName().startsWith(prefix)) continue;
            return this.frame.getVariable(name);
        }
        return Null.INSTANCE;
    }

    public boolean hasVariable(Symbol symbol2) {
        return this.frame.getVariable(symbol2) != Symbol.UNBOUND_VALUE;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        this.unsafeSetAttributes(attributes2);
        return this;
    }

    public String toString() {
        return "<environment: " + this.getName() + ">";
    }

    public Environment insertAbove(Frame frame2) {
        Environment newEnv = Environment.createChildEnvironment(this.parent, frame2);
        this.setParent(newEnv);
        return newEnv;
    }

    @Override
    public Iterable<NamedValue> namedValues() {
        return new NamedValues();
    }

    private static class BoundValue
    implements NamedValue {
        private Symbol name;
        private SEXP value;

        private BoundValue() {
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public String getName() {
            return this.name.getPrintName();
        }

        @Override
        public SEXP getValue() {
            return this.value;
        }
    }

    private class NamedValueIterator
    extends UnmodifiableIterator<NamedValue> {
        private Iterator<Symbol> names;

        private NamedValueIterator() {
            this.names = Environment.this.getSymbolNames().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public NamedValue next() {
            BoundValue boundValue = new BoundValue();
            Symbol name = this.names.next();
            boundValue.name = name;
            boundValue.value = Environment.this.getVariable(name);
            return boundValue;
        }
    }

    private class NamedValues
    implements Iterable<NamedValue> {
        private NamedValues() {
        }

        @Override
        public Iterator<NamedValue> iterator() {
            return new NamedValueIterator();
        }
    }

    private static class EmptyEnv
    extends Environment {
        private EmptyEnv() {
        }

        @Override
        public Collection<Symbol> getSymbolNames() {
            return Collections.emptySet();
        }

        @Override
        public SEXP findVariable(Context context, Symbol symbol2, Predicate<SEXP> predicate, boolean inherits2) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public SEXP findVariable(Symbol symbol2) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public SEXP getVariable(Symbol symbol2) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public int getCumulativeModCount() {
            return 0;
        }

        @Override
        public Function findFunction(Context context, Symbol symbol2) {
            return null;
        }

        @Override
        public Environment getParent() {
            throw new UnsupportedOperationException("The empty environment does not have a parent.");
        }

        @Override
        public void setParent(Environment parent2) {
            throw new UnsupportedOperationException("The empty environment does not have a parent.");
        }
    }

    private static class EnvIterator
    extends UnmodifiableIterator<Environment> {
        private Environment next;

        private EnvIterator(Environment next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != EMPTY;
        }

        @Override
        public Environment next() {
            Environment toReturn = this.next;
            this.next = this.next.parent;
            return toReturn;
        }
    }
}

