/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.AbstractRealMatrix;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixChangingVisitor;
import org.apache.commons.math.linear.RealMatrixPreservingVisitor;

@Deprecated
public class RealMatrixImpl
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = -1067294169172445528L;
    protected double[][] data;

    public RealMatrixImpl() {
    }

    public RealMatrixImpl(int rowDimension, int columnDimension) throws IllegalArgumentException {
        super(rowDimension, columnDimension);
        this.data = new double[rowDimension][columnDimension];
    }

    public RealMatrixImpl(double[][] d) throws IllegalArgumentException, NullPointerException {
        this.copyIn(d);
    }

    public RealMatrixImpl(double[][] d, boolean copyArray) throws IllegalArgumentException, NullPointerException {
        if (copyArray) {
            this.copyIn(d);
        } else {
            if (d == null) {
                throw new NullPointerException();
            }
            int nRows = d.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            for (int r = 1; r < nRows; ++r) {
                if (d[r].length == nCols) continue;
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d[r].length);
            }
            this.data = d;
        }
    }

    public RealMatrixImpl(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        for (int row2 = 0; row2 < nRows; ++row2) {
            this.data[row2][0] = v[row2];
        }
    }

    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        return new RealMatrixImpl(rowDimension, columnDimension);
    }

    public RealMatrix copy() {
        return new RealMatrixImpl(this.copyOut(), false);
    }

    public RealMatrix add(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.add((RealMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            return super.add(m);
        }
    }

    public RealMatrixImpl add(RealMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row2 = 0; row2 < rowCount; ++row2) {
            double[] dataRow = this.data[row2];
            double[] mRow = m.data[row2];
            double[] outDataRow = outData[row2];
            for (int col2 = 0; col2 < columnCount; ++col2) {
                outDataRow[col2] = dataRow[col2] + mRow[col2];
            }
        }
        return new RealMatrixImpl(outData, false);
    }

    public RealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.subtract((RealMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            return super.subtract(m);
        }
    }

    public RealMatrixImpl subtract(RealMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row2 = 0; row2 < rowCount; ++row2) {
            double[] dataRow = this.data[row2];
            double[] mRow = m.data[row2];
            double[] outDataRow = outData[row2];
            for (int col2 = 0; col2 < columnCount; ++col2) {
                outDataRow[col2] = dataRow[col2] - mRow[col2];
            }
        }
        return new RealMatrixImpl(outData, false);
    }

    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.multiply((RealMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            return super.multiply(m);
        }
    }

    public RealMatrixImpl multiply(RealMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        double[][] outData = new double[nRows][nCols];
        for (int row2 = 0; row2 < nRows; ++row2) {
            double[] dataRow = this.data[row2];
            double[] outDataRow = outData[row2];
            for (int col2 = 0; col2 < nCols; ++col2) {
                double sum2 = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum2 += dataRow[i] * m.data[i][col2];
                }
                outDataRow[col2] = sum2;
            }
        }
        return new RealMatrixImpl(outData, false);
    }

    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    public void setSubMatrix(double[][] subMatrix, int row2, int column) throws MatrixIndexException {
        if (this.data == null) {
            if (row2 > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row2);
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            this.data = new double[subMatrix.length][nCols];
            for (int i = 0; i < this.data.length; ++i) {
                if (subMatrix[i].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[i].length);
                }
                System.arraycopy(subMatrix[i], 0, this.data[i + row2], column, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row2, column);
        }
    }

    public double getEntry(int row2, int column) throws MatrixIndexException {
        try {
            return this.data[row2][column];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row2, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public void setEntry(int row2, int column, double value) throws MatrixIndexException {
        try {
            this.data[row2][column] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row2, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public void addToEntry(int row2, int column, double increment) throws MatrixIndexException {
        try {
            double[] dArray = this.data[row2];
            int n = column;
            dArray[n] = dArray[n] + increment;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row2, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public void multiplyEntry(int row2, int column, double factor) throws MatrixIndexException {
        try {
            double[] dArray = this.data[row2];
            int n = column;
            dArray[n] = dArray[n] * factor;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row2, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    public double[] operate(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nCols);
        }
        double[] out = new double[nRows];
        for (int row2 = 0; row2 < nRows; ++row2) {
            double[] dataRow = this.data[row2];
            double sum2 = 0.0;
            for (int i = 0; i < nCols; ++i) {
                sum2 += dataRow[i] * v[i];
            }
            out[row2] = sum2;
        }
        return out;
    }

    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nRows);
        }
        double[] out = new double[nCols];
        for (int col2 = 0; col2 < nCols; ++col2) {
            double sum2 = 0.0;
            for (int i = 0; i < nRows; ++i) {
                sum2 += this.data[i][col2] * v[i];
            }
            out[col2] = sum2;
        }
        return out;
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            double[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            double[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            double[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            double[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                double[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                double[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    private double[][] copyOut() {
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][this.getColumnDimension()];
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
        }
        return out;
    }

    private void copyIn(double[][] in) {
        this.setSubMatrix(in, 0, 0);
    }
}

