/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DecoratedFileObject;
import org.apache.commons.vfs2.impl.DefaultVfsComponentContext;
import org.apache.commons.vfs2.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs2.impl.FileTypeMap;
import org.apache.commons.vfs2.impl.URLStreamHandlerProxy;
import org.apache.commons.vfs2.impl.VirtualFileProvider;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.LocalFileProvider;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileSystemManager
implements FileSystemManager {
    private LocalFileProvider localFileProvider;
    private FileProvider defaultProvider;
    private FileReplicator fileReplicator;
    private final Map<String, FileProvider> providers = new HashMap<String, FileProvider>();
    private final ArrayList<Object> components = new ArrayList();
    private FileObject baseFile;
    private FilesCache filesCache;
    private CacheStrategy fileCacheStrategy;
    private Class<?> fileObjectDecorator;
    private Constructor<?> fileObjectDecoratorConst;
    private FileContentInfoFactory fileContentInfoFactory;
    private Log log = LogFactory.getLog(this.getClass());
    private final DefaultVfsComponentContext context = new DefaultVfsComponentContext(this);
    private TemporaryFileStore tempFileStore;
    private final FileTypeMap map = new FileTypeMap();
    private final VirtualFileProvider vfsProvider = new VirtualFileProvider();
    private boolean init;
    private final Map<String, List<FileOperationProvider>> operationProviders = new HashMap<String, List<FileOperationProvider>>();

    protected Log getLogger() {
        return this.log;
    }

    public void addProvider(String urlScheme, FileProvider provider) throws FileSystemException {
        this.addProvider(new String[]{urlScheme}, provider);
    }

    public void addProvider(String[] urlSchemes, FileProvider provider) throws FileSystemException {
        String scheme;
        int i;
        for (i = 0; i < urlSchemes.length; ++i) {
            scheme = urlSchemes[i];
            if (!this.providers.containsKey(scheme)) continue;
            throw new FileSystemException("vfs.impl/multiple-providers-for-scheme.error", scheme);
        }
        this.setupComponent(provider);
        for (i = 0; i < urlSchemes.length; ++i) {
            scheme = urlSchemes[i];
            this.providers.put(scheme, provider);
        }
        if (provider instanceof LocalFileProvider && this.localFileProvider == null) {
            this.localFileProvider = (LocalFileProvider)provider;
        }
    }

    @Override
    public boolean hasProvider(String scheme) {
        return this.providers.containsKey(scheme);
    }

    public void addExtensionMap(String extension, String scheme) {
        this.map.addExtension(extension, scheme);
    }

    public void addMimeTypeMap(String mimeType, String scheme) {
        this.map.addMimeType(mimeType, scheme);
    }

    public void setDefaultProvider(FileProvider provider) throws FileSystemException {
        this.setupComponent(provider);
        this.defaultProvider = provider;
    }

    @Override
    public FilesCache getFilesCache() {
        return this.filesCache;
    }

    public void setFilesCache(FilesCache filesCache) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.filesCache = filesCache;
    }

    public void setCacheStrategy(CacheStrategy fileCacheStrategy) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileCacheStrategy = fileCacheStrategy;
    }

    @Override
    public CacheStrategy getCacheStrategy() {
        return this.fileCacheStrategy;
    }

    @Override
    public Class<?> getFileObjectDecorator() {
        return this.fileObjectDecorator;
    }

    @Override
    public Constructor<?> getFileObjectDecoratorConst() {
        return this.fileObjectDecoratorConst;
    }

    public void setFileObjectDecorator(Class<?> fileObjectDecorator) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        if (!DecoratedFileObject.class.isAssignableFrom(fileObjectDecorator)) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", fileObjectDecorator.getName());
        }
        try {
            this.fileObjectDecoratorConst = fileObjectDecorator.getConstructor(FileObject.class);
        }
        catch (NoSuchMethodException e) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", fileObjectDecorator.getName(), (Throwable)e);
        }
        this.fileObjectDecorator = fileObjectDecorator;
    }

    @Override
    public FileContentInfoFactory getFileContentInfoFactory() {
        return this.fileContentInfoFactory;
    }

    public void setFileContentInfoFactory(FileContentInfoFactory fileContentInfoFactory) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    public void setReplicator(FileReplicator replicator) throws FileSystemException {
        this.setupComponent(replicator);
        this.fileReplicator = replicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore tempFileStore) throws FileSystemException {
        this.setupComponent(tempFileStore);
        this.tempFileStore = tempFileStore;
    }

    @Override
    public void setLogger(Log log3) {
        this.log = log3;
    }

    private void setupComponent(Object component) throws FileSystemException {
        if (!this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.context);
                vfsComponent.init();
            }
            this.components.add(component);
        }
    }

    private void closeComponent(Object component) {
        if (component != null && this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.close();
            }
            this.components.remove(component);
        }
    }

    public FileReplicator getReplicator() throws FileSystemException {
        if (this.fileReplicator == null) {
            throw new FileSystemException("vfs.impl/no-replicator.error");
        }
        return this.fileReplicator;
    }

    public TemporaryFileStore getTemporaryFileStore() throws FileSystemException {
        if (this.tempFileStore == null) {
            throw new FileSystemException("vfs.impl/no-temp-file-store.error");
        }
        return this.tempFileStore;
    }

    public void init() throws FileSystemException {
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new FileContentInfoFilenameFactory();
        }
        if (this.fileCacheStrategy == null) {
            this.fileCacheStrategy = CacheStrategy.ON_RESOLVE;
        }
        this.setupComponent(this.filesCache);
        this.setupComponent(this.vfsProvider);
        this.init = true;
    }

    public void close() {
        if (!this.init) {
            return;
        }
        for (FileProvider provider : this.providers.values()) {
            this.closeComponent(provider);
        }
        this.closeComponent(this.defaultProvider);
        this.closeComponent(this.fileReplicator);
        this.closeComponent(this.tempFileStore);
        this.components.clear();
        this.providers.clear();
        this.filesCache.close();
        this.localFileProvider = null;
        this.defaultProvider = null;
        this.fileReplicator = null;
        this.tempFileStore = null;
        this.init = false;
    }

    public void freeUnusedResources() {
        if (!this.init) {
            return;
        }
        for (AbstractFileProvider abstractFileProvider : this.providers.values()) {
            abstractFileProvider.freeUnusedResources();
        }
    }

    public void setBaseFile(FileObject baseFile) throws FileSystemException {
        this.baseFile = baseFile;
    }

    public void setBaseFile(File baseFile) throws FileSystemException {
        this.baseFile = this.getLocalFileProvider().findLocalFile(baseFile);
    }

    @Override
    public FileObject getBaseFile() throws FileSystemException {
        return this.baseFile;
    }

    @Override
    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri);
    }

    @Override
    public FileObject resolveFile(String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), uri, fileSystemOptions);
    }

    @Override
    public FileObject resolveFile(File baseFile, String uri) throws FileSystemException {
        FileObject baseFileObj = this.getLocalFileProvider().findLocalFile(baseFile);
        return this.resolveFile(baseFileObj, uri);
    }

    @Override
    public FileObject resolveFile(FileObject baseFile, String uri) throws FileSystemException {
        return this.resolveFile(baseFile, uri, baseFile == null ? null : baseFile.getFileSystem().getFileSystemOptions());
    }

    public FileObject resolveFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileProvider provider;
        FileObject realBaseFile = baseFile != null && VFS.isUriStyle() && baseFile.getName().getType() == FileType.FILE ? baseFile.getParent() : baseFile;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = this.providers.get(scheme)) != null) {
            return provider.findFile(realBaseFile, uri, fileSystemOptions);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.findLocalFile(uri);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme, uri});
            }
            return this.defaultProvider.findFile(realBaseFile, uri, fileSystemOptions);
        }
        if (realBaseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", uri);
        }
        return realBaseFile.resolveFile(uri);
    }

    @Override
    public FileName resolveName(FileName root, String path2) throws FileSystemException {
        return this.resolveName(root, path2, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileName resolveName(FileName base, String name, NameScope scope) throws FileSystemException {
        String fullPath;
        FileName realBase = base != null && VFS.isUriStyle() && base.getType() == FileType.FILE ? base.getParent() : base;
        StringBuilder buffer = new StringBuilder(name);
        UriParser.fixSeparators(buffer);
        String scheme = UriParser.extractScheme(buffer.toString());
        if (name.length() == 0 || scheme == null && buffer.charAt(0) != '/') {
            if (!VFS.isUriStyle()) {
                buffer.insert(0, '/');
            }
            buffer.insert(0, realBase.getPath());
        }
        FileType fileType = UriParser.normalisePath(buffer);
        String resolvedPath = buffer.toString();
        if (!AbstractFileName.checkName(realBase.getPath(), resolvedPath, scope)) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", name);
        }
        if (scheme != null) {
            fullPath = resolvedPath;
        } else {
            scheme = realBase.getScheme();
            fullPath = realBase.getRootURI() + resolvedPath;
        }
        FileProvider provider = this.providers.get(scheme);
        if (provider != null) {
            return provider.parseUri(realBase, fullPath);
        }
        if (scheme != null && this.defaultProvider != null) {
            return this.defaultProvider.parseUri(realBase, fullPath);
        }
        return ((AbstractFileName)realBase).createName(resolvedPath, fileType);
    }

    @Override
    public FileName resolveURI(String uri) throws FileSystemException {
        FileProvider provider;
        UriParser.checkUriEncoding(uri);
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = UriParser.extractScheme(uri);
        if (scheme != null && (provider = this.providers.get(scheme)) != null) {
            return provider.parseUri(null, uri);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(uri)) {
            return this.localFileProvider.parseUri(null, uri);
        }
        if (scheme != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme, uri});
            }
            return this.defaultProvider.parseUri(null, uri);
        }
        if (this.baseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", uri);
        }
        return this.resolveName(this.baseFile.getName(), uri, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileObject toFileObject(File file2) throws FileSystemException {
        return this.getLocalFileProvider().findLocalFile(file2);
    }

    @Override
    public FileObject createFileSystem(String scheme, FileObject file2) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-provider.error", new Object[]{scheme, file2});
        }
        return provider.createFileSystem(scheme, file2, file2.getFileSystem().getFileSystemOptions());
    }

    @Override
    public FileObject createFileSystem(FileObject file2) throws FileSystemException {
        String scheme = this.map.getScheme(file2);
        if (scheme == null) {
            throw new FileSystemException("vfs.impl/no-provider-for-file.error", file2);
        }
        return this.createFileSystem(scheme, file2);
    }

    @Override
    public boolean canCreateFileSystem(FileObject file2) throws FileSystemException {
        return this.map.getScheme(file2) != null;
    }

    @Override
    public FileObject createVirtualFileSystem(FileObject rootFile) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootFile);
    }

    @Override
    public FileObject createVirtualFileSystem(String rootUri) throws FileSystemException {
        return this.vfsProvider.createFileSystem(rootUri);
    }

    private LocalFileProvider getLocalFileProvider() throws FileSystemException {
        if (this.localFileProvider == null) {
            throw new FileSystemException("vfs.impl/no-local-file-provider.error");
        }
        return this.localFileProvider;
    }

    @Override
    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return new VfsStreamHandlerFactory();
    }

    @Override
    public void closeFileSystem(FileSystem filesystem) {
        this.getFilesCache().clear(filesystem);
        this._closeFileSystem(filesystem);
    }

    public void _closeFileSystem(FileSystem filesystem) {
        FileProvider provider = this.providers.get(filesystem.getRootName().getScheme());
        if (provider != null) {
            ((AbstractFileProvider)provider).closeFileSystem(filesystem);
        }
    }

    @Override
    public String[] getSchemes() {
        String[] schemes = new String[this.providers.size()];
        this.providers.keySet().toArray(schemes);
        return schemes;
    }

    @Override
    public Collection<Capability> getProviderCapabilities(String scheme) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme});
        }
        return provider.getCapabilities();
    }

    @Override
    public FileSystemConfigBuilder getFileSystemConfigBuilder(String scheme) throws FileSystemException {
        FileProvider provider = this.providers.get(scheme);
        if (provider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{scheme});
        }
        return provider.getConfigBuilder();
    }

    @Override
    public void addOperationProvider(String scheme, FileOperationProvider operationProvider) throws FileSystemException {
        this.addOperationProvider(new String[]{scheme}, operationProvider);
    }

    @Override
    public void addOperationProvider(String[] schemes, FileOperationProvider operationProvider) throws FileSystemException {
        for (int i = 0; i < schemes.length; ++i) {
            List<Object> providers;
            String scheme = schemes[i];
            if (!this.operationProviders.containsKey(scheme)) {
                providers = new ArrayList();
                this.operationProviders.put(scheme, providers);
            }
            if ((providers = this.operationProviders.get(scheme)).contains(operationProvider)) {
                throw new FileSystemException("vfs.operation/operation-provider-already-added.error", scheme);
            }
            this.setupComponent(operationProvider);
            providers.add(operationProvider);
        }
    }

    @Override
    public FileOperationProvider[] getOperationProviders(String scheme) throws FileSystemException {
        List<FileOperationProvider> providers = this.operationProviders.get(scheme);
        if (providers == null || providers.size() == 0) {
            return null;
        }
        return providers.toArray(new FileOperationProvider[0]);
    }

    final class VfsStreamHandlerFactory
    implements URLStreamHandlerFactory {
        VfsStreamHandlerFactory() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            FileProvider provider = (FileProvider)DefaultFileSystemManager.this.providers.get(protocol);
            if (provider != null) {
                return new DefaultURLStreamHandler(DefaultFileSystemManager.this.context);
            }
            return new URLStreamHandlerProxy();
        }
    }
}

