/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.vfs2.provider.tar.TarUtils;

class TarEntry {
    public static final int NAMELEN = 100;
    private int checkSum;
    private int devMajor;
    private int devMinor;
    private File file;
    private int groupID;
    private StringBuffer groupName;
    private byte linkFlag;
    private StringBuffer linkName;
    private StringBuffer magic = new StringBuffer("ustar");
    private long modTime;
    private int mode;
    private StringBuffer name = new StringBuffer();
    private long size;
    private int userID;
    private StringBuffer userName;

    TarEntry(String name) {
        this();
        boolean isDir = name.endsWith("/");
        this.name = new StringBuffer(name);
        this.mode = isDir ? 16877 : 33188;
        this.linkFlag = (byte)(isDir ? 53 : 48);
        this.modTime = new Date().getTime() / 1000L;
        this.linkName = new StringBuffer("");
        this.userName = new StringBuffer("");
        this.groupName = new StringBuffer("");
    }

    TarEntry(String name, byte linkFlag) {
        this(name);
        this.linkFlag = linkFlag;
    }

    TarEntry(File file2) {
        this();
        int colon2;
        this.file = file2;
        String name = file2.getPath();
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (-1 != osName.indexOf("netware")) {
            if (name.length() > 2) {
                char ch1 = name.charAt(0);
                char ch2 = name.charAt(1);
                if (ch2 == ':' && (ch1 >= 'a' && ch1 <= 'z' || ch1 >= 'A' && ch1 <= 'Z')) {
                    name = name.substring(2);
                }
            }
        } else if (-1 != osName.indexOf("netware") && (colon2 = name.indexOf(58)) != -1) {
            name = name.substring(colon2 + 1);
        }
        name = name.replace(File.separatorChar, '/');
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        this.linkName = new StringBuffer("");
        this.name = new StringBuffer(name);
        if (file2.isDirectory()) {
            this.mode = 16877;
            this.linkFlag = (byte)53;
            if (this.name.charAt(this.name.length() - 1) != '/') {
                this.name.append("/");
            }
        } else {
            this.mode = 33188;
            this.linkFlag = (byte)48;
        }
        this.size = file2.length();
        this.modTime = file2.lastModified() / 1000L;
        this.checkSum = 0;
        this.devMajor = 0;
        this.devMinor = 0;
    }

    TarEntry(byte[] header) {
        this();
        this.parseTarHeader(header);
    }

    private TarEntry() {
        this.linkName = new StringBuffer();
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userName = new StringBuffer(user);
        this.groupName = new StringBuffer("");
    }

    public void setGroupID(int groupId) {
        this.groupID = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = new StringBuffer(groupName);
    }

    public void setModTime(long time2) {
        this.modTime = time2 / 1000L;
    }

    public void setModTime(Date time2) {
        this.modTime = time2.getTime() / 1000L;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setName(String name) {
        this.name = new StringBuffer(name);
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setUserID(int userId) {
        this.userID = userId;
    }

    public void setUserName(String userName) {
        this.userName = new StringBuffer(userName);
    }

    public TarEntry[] getDirectoryEntries() {
        if (null == this.file || !this.file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] list2 = this.file.list();
        TarEntry[] result = new TarEntry[list2.length];
        for (int i = 0; i < list2.length; ++i) {
            result[i] = new TarEntry(new File(this.file, list2[i]));
        }
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public String getGroupName() {
        return this.groupName.toString();
    }

    public Date getModTime() {
        return new Date(this.modTime * 1000L);
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name.toString();
    }

    public long getSize() {
        return this.size;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public int getUserID() {
        return this.userID;
    }

    public String getUserName() {
        return this.userName.toString();
    }

    public boolean isDescendent(TarEntry desc) {
        return desc.getName().startsWith(this.getName());
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76 && this.name.toString().equals("././@LongLink");
    }

    public boolean equals(Object other) {
        if (!(other instanceof TarEntry)) {
            return false;
        }
        TarEntry entry = (TarEntry)other;
        return this.getName().equals(entry.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private void parseTarHeader(byte[] header) {
        int offset = 0;
        this.name = TarUtils.parseName(header, offset, 100);
        this.mode = (int)TarUtils.parseOctal(header, offset += 100, 8);
        this.userID = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.groupID = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.size = TarUtils.parseOctal(header, offset += 8, 12);
        this.modTime = TarUtils.parseOctal(header, offset += 12, 12);
        this.checkSum = (int)TarUtils.parseOctal(header, offset += 12, 8);
        offset += 8;
        this.linkFlag = header[offset++];
        this.linkName = TarUtils.parseName(header, offset, 100);
        this.magic = TarUtils.parseName(header, offset += 100, 8);
        this.userName = TarUtils.parseName(header, offset += 8, 32);
        this.groupName = TarUtils.parseName(header, offset += 32, 32);
        this.devMajor = (int)TarUtils.parseOctal(header, offset += 32, 8);
        this.devMinor = (int)TarUtils.parseOctal(header, offset += 8, 8);
    }

    public void writeEntryHeader(byte[] buffer) {
        int offset = 0;
        offset = TarUtils.getNameBytes(this.name, buffer, offset, 100);
        offset = TarUtils.getOctalBytes(this.mode, buffer, offset, 8);
        offset = TarUtils.getOctalBytes(this.userID, buffer, offset, 8);
        offset = TarUtils.getOctalBytes(this.groupID, buffer, offset, 8);
        offset = TarUtils.getLongOctalBytes(this.size, buffer, offset, 12);
        int checkSumOffset = offset = TarUtils.getLongOctalBytes(this.modTime, buffer, offset, 12);
        for (int i = 0; i < 8; ++i) {
            buffer[offset++] = 32;
        }
        buffer[offset++] = this.linkFlag;
        offset = TarUtils.getNameBytes(this.linkName, buffer, offset, 100);
        offset = TarUtils.getNameBytes(this.magic, buffer, offset, 8);
        offset = TarUtils.getNameBytes(this.userName, buffer, offset, 32);
        offset = TarUtils.getNameBytes(this.groupName, buffer, offset, 32);
        offset = TarUtils.getOctalBytes(this.devMajor, buffer, offset, 8);
        offset = TarUtils.getOctalBytes(this.devMinor, buffer, offset, 8);
        while (offset < buffer.length) {
            buffer[offset++] = 0;
        }
        long checkSum = TarUtils.computeCheckSum(buffer);
        TarUtils.getCheckSumOctalBytes(checkSum, buffer, checkSumOffset, 8);
    }
}

