/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.svnexe.command.AbstractFileCheckingConsumer;

public class SvnCheckOutConsumer
extends AbstractFileCheckingConsumer {
    private static final String CHECKED_OUT_REVISION_TOKEN = "Checked out revision";
    private List files = new ArrayList();

    public SvnCheckOutConsumer(ScmLogger logger, File workingDirectory) {
        super(logger, workingDirectory);
    }

    protected void parseLine(String line) {
        ScmFileStatus status;
        String statusString = line.substring(0, 1);
        String file2 = line.substring(3).trim();
        if (line.startsWith(CHECKED_OUT_REVISION_TOKEN)) {
            String revisionString = line.substring(CHECKED_OUT_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("U")) {
            status = ScmFileStatus.UPDATED;
        } else {
            return;
        }
        this.addFile(new ScmFile(file2, status));
    }

    public List getCheckedOutFiles() {
        return this.getFiles();
    }

    protected void addFile(ScmFile file2) {
        this.files.add(file2);
    }

    protected List getFiles() {
        ArrayList<ScmFile> onlyFiles = new ArrayList<ScmFile>();
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            ScmFile file2 = (ScmFile)it.next();
            if (!file2.getStatus().equals(ScmFileStatus.DELETED) && !new File(file2.getPath()).isFile()) continue;
            onlyFiles.add(file2);
        }
        return onlyFiles;
    }
}

