/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.cfg.CfgPredicates;
import org.renjin.compiler.cfg.FlowEdge;
import org.renjin.compiler.ir.ssa.PhiFunction;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.compiler.ir.tac.statements.ReturnStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.guava.base.Predicates;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;

public class BasicBlock {
    private final IRBody parent;
    private String debugId;
    private Set<IRLabel> labels;
    private List<Statement> statements = Lists.newArrayList();
    List<BasicBlock> flowSuccessors = new ArrayList<BasicBlock>();
    List<BasicBlock> flowPredecessors = new ArrayList<BasicBlock>();
    List<BasicBlock> dominanceSuccessors = new ArrayList<BasicBlock>();
    List<BasicBlock> dominancePredecessors = new ArrayList<BasicBlock>();
    final Set<FlowEdge> outgoing = new HashSet<FlowEdge>();
    final Set<FlowEdge> incoming = new HashSet<FlowEdge>();

    public BasicBlock(IRBody parent2) {
        this.parent = parent2;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public void insertPhiFunction(Variable variable, Set<FlowEdge> incomingEdges) {
        this.statements.add(0, new Assignment(variable, new PhiFunction(variable, incomingEdges)));
    }

    public Statement replaceStatement(Statement stmt, Statement newStmt) {
        int i = this.statements.indexOf(stmt);
        this.statements.set(i, newStmt);
        return newStmt;
    }

    public void replaceStatement(int i, Statement stmt) {
        this.statements.set(i, stmt);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setDebugId(int index) {
        this.debugId = "BB" + index;
    }

    public void setDebugId(String string) {
        this.debugId = string;
    }

    public static BasicBlock createWithStartAt(IRBody parent2, int statementIndex) {
        BasicBlock block = new BasicBlock(parent2);
        block.labels = parent2.getIntructionLabels(statementIndex);
        block.statements = Lists.newArrayList();
        block.statements.add(parent2.getStatements().get(statementIndex));
        return block;
    }

    public Set<IRLabel> getLabels() {
        return this.labels;
    }

    public boolean isLabeled() {
        return !this.labels.isEmpty();
    }

    public Statement getTerminal() {
        return this.statements.get(this.statements.size() - 1);
    }

    public void addFlowSuccessor(BasicBlock successor) {
        FlowEdge edge = new FlowEdge(this, successor);
        this.outgoing.add(edge);
        this.flowSuccessors.add(successor);
        successor.incoming.add(edge);
        successor.flowPredecessors.add(this);
    }

    public void addDominanceSuccessor(BasicBlock basicBlock) {
        this.dominanceSuccessors.add(basicBlock);
        basicBlock.dominancePredecessors.add(this);
    }

    public Set<FlowEdge> getIncoming() {
        return this.incoming;
    }

    public Set<FlowEdge> getOutgoing() {
        return this.outgoing;
    }

    public List<BasicBlock> getFlowSuccessors() {
        return this.flowSuccessors;
    }

    public List<BasicBlock> getFlowPredecessors() {
        return this.flowPredecessors;
    }

    public List<BasicBlock> getDominanceSuccessors() {
        return this.dominanceSuccessors;
    }

    public List<BasicBlock> getDominancePredecessors() {
        return this.dominancePredecessors;
    }

    public boolean returns() {
        return this.getTerminal() instanceof ReturnStatement;
    }

    public boolean fallsThrough() {
        Statement terminal = this.getTerminal();
        return !(terminal instanceof GotoStatement) && !(terminal instanceof IfStatement) && !(terminal instanceof ReturnStatement);
    }

    public Iterable<IRLabel> targets() {
        return this.getTerminal().possibleTargets();
    }

    public String statementsToString() {
        StringBuilder sb = new StringBuilder();
        for (Statement statement : this.statements) {
            sb.append(statement).append("\n");
        }
        return sb.toString();
    }

    public Iterable<Assignment> assignments() {
        return Iterables.filter(this.statements, Predicates.instanceOf(Assignment.class));
    }

    public Iterable<Assignment> phiAssignments() {
        return Iterables.filter(this.statements, CfgPredicates.isPhiAssignment());
    }

    public String toString() {
        return this.debugId;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public void addStatementBeforeJump(Assignment assignment) {
        int pos = this.getStatements().size();
        if (!this.fallsThrough()) {
            --pos;
        }
        this.getStatements().add(pos, assignment);
    }

    public int hashCode() {
        return this.debugId.hashCode();
    }
}

