/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class IRMatchedArguments {
    private final List<IRArgument> arguments;
    private final Map<Symbol, Integer> matchedFormals = new HashMap<Symbol, Integer>();
    private final List<Integer> extraArguments = Lists.newArrayList();

    public IRMatchedArguments(Closure closure, List<IRArgument> arguments) {
        this.arguments = arguments;
        if (IRArgument.anyNamed(arguments)) {
            throw new UnsupportedOperationException("TODO");
        }
        this.matchPositionally(closure);
    }

    public Set<Symbol> getSuppliedFormals() {
        return this.matchedFormals.keySet();
    }

    public Map<Symbol, Integer> getMatchedFormals() {
        return this.matchedFormals;
    }

    public boolean hasExtraArguments() {
        return !this.extraArguments.isEmpty();
    }

    private void matchPositionally(Closure closure) {
        int suppliedIndex = 0;
        int suppliedCount = this.arguments.size();
        PairList formal = closure.getFormals();
        while (suppliedIndex < suppliedCount && formal != Null.INSTANCE) {
            PairList.Node formalNode = (PairList.Node)formal;
            if (formalNode.getTag() != Symbols.ELLIPSES) {
                this.matchedFormals.put(formalNode.getTag(), suppliedIndex);
                ++suppliedIndex;
            }
            formal = formalNode.getNext();
        }
        while (suppliedIndex < suppliedCount) {
            this.extraArguments.add(suppliedIndex++);
        }
    }
}

