/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics.internals;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.graphics.GraphicsDevice;
import org.renjin.graphics.GraphicsDevices;
import org.renjin.graphics.geom.Point;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Recycle;

public class Graphics {
    public static final int DEVICE = 1;
    public static final int NDC = 2;
    public static final int NIC = 7;
    public static final int NFC = 8;
    public static final int USER = 13;
    public static final int INCHES = 14;
    public static final int NPC = 17;

    @Internal
    @DataParallel
    public static double grconvertX(@Current Context context, @Recycle double x, int from, int to) {
        return Graphics.grConvert(context, new Point(x, Double.NaN), from, to).getX();
    }

    @Internal
    @DataParallel
    public static double grconvertY(@Current Context context, @Recycle double y, int from, int to) {
        return Graphics.grConvert(context, new Point(Double.NaN, y), from, to).getY();
    }

    private static Point grConvert(Context context, Point point, int from, int to) {
        GraphicsDevice active = context.getSession().getSingleton(GraphicsDevices.class).getActive();
        Point device = Graphics.toDeviceCoordinates(active, point, from);
        return Graphics.fromDeviceCoordinates(active, device, to);
    }

    private static Point toDeviceCoordinates(GraphicsDevice active, Point point, int from) {
        switch (from) {
            case 13: {
                return active.userToDevice(point);
            }
        }
        throw new EvalException("Invalid 'from' argument", new Object[0]);
    }

    private static Point fromDeviceCoordinates(GraphicsDevice active, Point point, int to) {
        switch (to) {
            case 1: {
                return point;
            }
        }
        throw new EvalException("Invalid 'to' argument", new Object[0]);
    }
}

