/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bessel_k;
import org.renjin.nmath.cospi;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.gamma_cody;
import org.renjin.nmath.mlutils;

public class bessel_i {
    public static double $I_bessel$const__ = 1.585;

    private bessel_i() {
    }

    public static void I_bessel(DoublePtr doublePtr, DoublePtr doublePtr2, IntPtr intPtr, IntPtr intPtr2, DoublePtr doublePtr3, IntPtr intPtr3) {
        block44: {
            int n;
            int nb$offset;
            int[] nb$array;
            block42: {
                int n2;
                double[] dArray;
                double d;
                int n3;
                double empal;
                double aa;
                double bb;
                double cc;
                double tover;
                double nu;
                int ncalc$offset;
                int[] ncalc$array;
                int bi$offset;
                double[] bi$array;
                int ize$offset;
                int[] ize$array;
                int x$offset;
                double[] x$array;
                block46: {
                    double sum2;
                    block50: {
                        block51: {
                            double d2;
                            int l;
                            int nend;
                            double en;
                            double emp2al;
                            block48: {
                                double d3;
                                block49: {
                                    double em;
                                    block47: {
                                        double p;
                                        double twonu;
                                        block41: {
                                            double d4;
                                            double d5;
                                            double pold;
                                            int nstart;
                                            double test;
                                            double psave;
                                            double psavel;
                                            block45: {
                                                block43: {
                                                    int n4;
                                                    x$array = doublePtr.array;
                                                    x$offset = doublePtr.offset;
                                                    double[] alpha$array = doublePtr2.array;
                                                    int alpha$offset = doublePtr2.offset;
                                                    nb$array = intPtr.array;
                                                    nb$offset = intPtr.offset;
                                                    ize$array = intPtr2.array;
                                                    ize$offset = intPtr2.offset;
                                                    bi$array = doublePtr3.array;
                                                    bi$offset = doublePtr3.offset;
                                                    ncalc$array = intPtr3.array;
                                                    ncalc$offset = intPtr3.offset;
                                                    twonu = 0.0;
                                                    nu = 0.0;
                                                    sum2 = 0.0;
                                                    psavel = 0.0;
                                                    tover = 0.0;
                                                    psave = 0.0;
                                                    cc = 0.0;
                                                    bb = 0.0;
                                                    aa = 0.0;
                                                    emp2al = 0.0;
                                                    empal = 0.0;
                                                    en = 0.0;
                                                    em = 0.0;
                                                    p = 0.0;
                                                    test = 0.0;
                                                    nstart = 0;
                                                    n3 = 0;
                                                    nend = 0;
                                                    --bi$offset;
                                                    nu = alpha$array[alpha$offset];
                                                    twonu = nu * 2.0;
                                                    if (!(nb$array[nb$offset] > 0 && x$array[x$offset] >= 0.0 && nu >= 0.0 && nu < 1.0 && ize$array[ize$offset] > 0 && ize$array[ize$offset] <= 2)) break block42;
                                                    ncalc$array[ncalc$offset] = n4 = nb$array[nb$offset];
                                                    if (ize$array[ize$offset] != 1 || !(x$array[x$offset] > 709.0)) break block43;
                                                    int k = 1;
                                                    while (nb$array[nb$offset] >= k) {
                                                        double d6;
                                                        int n5 = k * 8;
                                                        double[] dArray2 = bi$array;
                                                        int n6 = bi$offset + n5 / 8;
                                                        dArray2[n6] = d6 = 1.0 / 0.0;
                                                        ++k;
                                                    }
                                                    break block44;
                                                }
                                                if (ize$array[ize$offset] != 2 || !(x$array[x$offset] > 100000.0)) break block45;
                                                int k = 1;
                                                while (nb$array[nb$offset] >= k) {
                                                    int n7 = k * 8;
                                                    double[] dArray3 = bi$array;
                                                    int n8 = bi$offset + n7 / 8;
                                                    dArray3[n8] = 0.0;
                                                    ++k;
                                                }
                                                break block44;
                                            }
                                            int intx = (int)x$array[x$offset];
                                            if (!(x$array[x$offset] >= 1.0E-4)) break block46;
                                            int nbmx = nb$array[nb$offset] - intx;
                                            int n9 = n3 = intx + 1;
                                            en = (double)(n9 + n9) + twonu;
                                            double plast = 1.0;
                                            double d7 = x$array[x$offset];
                                            p = en / d7;
                                            test = 2.0E16;
                                            if (intx << 1 > 80) {
                                                test = Mathlib.sqrt(test * p);
                                            } else {
                                                double d8 = mlutils.R_pow_di($I_bessel$const__, intx);
                                                test /= d8;
                                            }
                                            if (nbmx > 2) {
                                                tover = 1.0E292;
                                                nstart = intx + 2;
                                                nend = nb$array[nb$offset] + -1;
                                                int k = nstart;
                                                while (k <= nend) {
                                                    int n10;
                                                    block40: {
                                                        int n11;
                                                        double d9;
                                                        double d10;
                                                        n3 = k++;
                                                        plast = p;
                                                        double d11 = (en += 2.0) * plast;
                                                        double d12 = x$array[x$offset];
                                                        pold = plast;
                                                        if (!((p = d11 / d12 + pold) > tover)) continue;
                                                        tover = 1.0E308;
                                                        psave = p /= tover;
                                                        psavel = plast /= tover;
                                                        nstart = n3 + 1;
                                                        do {
                                                            ++n3;
                                                        } while ((p = (d10 = (en += 2.0) * (plast = p)) / (d9 = x$array[x$offset]) + (pold = plast)) <= 1.0);
                                                        double d13 = x$array[x$offset];
                                                        bb = en / d13;
                                                        test = pold * plast / 1.0E16;
                                                        double d14 = bb;
                                                        double d15 = d14 * d14;
                                                        double d16 = 0.5 / d15;
                                                        test = (0.5 - d16) * test;
                                                        p = plast * tover;
                                                        en -= 2.0;
                                                        nend = Math.min(nb$array[nb$offset], --n3);
                                                        l = nstart;
                                                        while (l <= nend) {
                                                            ncalc$array[ncalc$offset] = l++;
                                                            psavel = psave;
                                                            double d17 = en * psavel;
                                                            double d18 = x$array[x$offset];
                                                            pold = psavel;
                                                            if (!((psave = d17 / d18 + pold) * psavel > test)) {
                                                                continue;
                                                            }
                                                            break block40;
                                                        }
                                                        ncalc$array[ncalc$offset] = n11 = nend + 1;
                                                    }
                                                    ncalc$array[ncalc$offset] = n10 = ncalc$array[ncalc$offset] - 1;
                                                    break block41;
                                                }
                                                int n12 = n3 = nend;
                                                en = (double)(n12 + n12) + twonu;
                                                double d19 = Mathlib.sqrt(plast * 1.0E16);
                                                double d20 = Mathlib.sqrt(p * 2.0);
                                                double d21 = d19 * d20;
                                                test = fmax2.fmax2(test, d21);
                                            }
                                            do {
                                                ++n3;
                                            } while ((p = (d5 = (en += 2.0) * (plast = p)) / (d4 = x$array[x$offset]) + (pold = plast)) < test);
                                        }
                                        en += 2.0;
                                        bb = 0.0;
                                        aa = 1.0 / p;
                                        em = (double)(++n3) - 1.0;
                                        empal = em + nu;
                                        emp2al = em - 1.0 + twonu;
                                        sum2 = aa * empal * emp2al / em;
                                        int n13 = nb$array[nb$offset];
                                        nend = n3 - n13;
                                        if (nend >= 0) break block47;
                                        int n14 = n3 * 8;
                                        double[] dArray4 = bi$array;
                                        int n15 = bi$offset + n14 / 8;
                                        dArray4[n15] = aa;
                                        nend = -nend;
                                        l = 1;
                                        while (l <= nend) {
                                            int n16 = (n3 + l) * 8;
                                            double[] dArray5 = bi$array;
                                            int n17 = bi$offset + n16 / 8;
                                            dArray5[n17] = 0.0;
                                            ++l;
                                        }
                                        break block48;
                                    }
                                    if (nend > 0) {
                                        l = 1;
                                        while (l <= nend) {
                                            --n3;
                                            en -= 2.0;
                                            cc = bb;
                                            bb = aa;
                                            if (nend > 100 && aa > 1.0E200) {
                                                cc = Mathlib.ldexp(cc, -900);
                                                bb = Mathlib.ldexp(bb, -900);
                                                sum2 = Mathlib.ldexp(sum2, -900);
                                            }
                                            double d22 = en * bb;
                                            double d23 = x$array[x$offset];
                                            aa = d22 / d23 + cc;
                                            em -= 1.0;
                                            emp2al -= 1.0;
                                            if (n3 == 1) break;
                                            if (n3 == 2) {
                                                emp2al = 1.0;
                                            }
                                            sum2 = (aa * (empal -= 1.0) + sum2) * emp2al / em;
                                            ++l;
                                        }
                                    }
                                    int n18 = n3 * 8;
                                    double[] dArray6 = bi$array;
                                    int n19 = bi$offset + n18 / 8;
                                    dArray6[n19] = aa;
                                    if (nb$array[nb$offset] > 1) break block49;
                                    sum2 = sum2 * 2.0 + aa;
                                    break block50;
                                }
                                int n20 = --n3 * 8;
                                double[] dArray7 = bi$array;
                                int n21 = bi$offset + n20 / 8;
                                double d24 = (en -= 2.0) * aa;
                                double d25 = x$array[x$offset];
                                dArray7[n21] = d3 = d24 / d25 + bb;
                                if (n3 == 1) break block51;
                                emp2al = n3 == 2 ? 1.0 : (emp2al -= 1.0);
                                int n22 = n3 * 8;
                                double[] dArray8 = bi$array;
                                int n23 = bi$offset + n22 / 8;
                                sum2 = (dArray8[n23] * (empal -= 1.0) + sum2) * emp2al / (em -= 1.0);
                            }
                            nend = n3 + -2;
                            if (nend > 0) {
                                l = 1;
                                while (l <= nend) {
                                    double d26;
                                    en -= 2.0;
                                    int n24 = --n3 * 8;
                                    double[] dArray9 = bi$array;
                                    int n25 = bi$offset + n24 / 8;
                                    int n26 = (n3 + 1) * 8;
                                    double[] dArray10 = bi$array;
                                    int n27 = bi$offset + n26 / 8;
                                    double d27 = dArray10[n27] * en;
                                    double d28 = x$array[x$offset];
                                    double d29 = d27 / d28;
                                    int n28 = (n3 + 2) * 8;
                                    double[] dArray11 = bi$array;
                                    int n29 = bi$offset + n28 / 8;
                                    double d30 = dArray11[n29];
                                    dArray9[n25] = d26 = d29 + d30;
                                    emp2al = n3 == 2 ? 1.0 : (emp2al -= 1.0);
                                    int n30 = n3 * 8;
                                    double[] dArray12 = bi$array;
                                    int n31 = bi$offset + n30 / 8;
                                    sum2 = (dArray12[n31] * (empal -= 1.0) + sum2) * emp2al / (em -= 1.0);
                                    ++l;
                                }
                            }
                            double[] dArray13 = bi$array;
                            int n32 = bi$offset + 1;
                            double d31 = empal * 2.0;
                            double[] dArray14 = bi$array;
                            int n33 = bi$offset + 2;
                            double d32 = dArray14[n33];
                            double d33 = d31 * d32;
                            double d34 = x$array[x$offset];
                            double d35 = d33 / d34;
                            double[] dArray15 = bi$array;
                            int n34 = bi$offset + 3;
                            double d36 = dArray15[n34];
                            dArray13[n32] = d2 = d35 + d36;
                        }
                        double d37 = sum2 * 2.0;
                        double[] dArray16 = bi$array;
                        int n35 = bi$offset + 1;
                        double d38 = dArray16[n35];
                        sum2 = d37 + d38;
                    }
                    if (nu != 0.0) {
                        double d39 = gamma_cody.Rf_gamma_cody(nu + 1.0);
                        double d40 = -nu;
                        double d41 = Mathlib.pow(x$array[x$offset] * 0.5, d40);
                        sum2 = d39 * d41 * sum2;
                    }
                    if (ize$array[ize$offset] == 1) {
                        sum2 = Math.exp(-x$array[x$offset]) * sum2;
                    }
                    aa = 8.9E-308;
                    if (sum2 > 1.0) {
                        aa *= sum2;
                    }
                    n3 = 1;
                    while (nb$array[nb$offset] >= n3) {
                        double[] dArray17 = bi$array;
                        int n36 = n3 * 8;
                        int n37 = bi$offset + n36 / 8;
                        if (dArray17[n37] < aa) {
                            int n38 = n3 * 8;
                            double[] dArray18 = bi$array;
                            int n39 = bi$offset + n38 / 8;
                            dArray18[n39] = 0.0;
                        } else {
                            double d42;
                            int n40 = n3 * 8;
                            double[] dArray19 = bi$array;
                            int n41 = bi$offset + n40 / 8;
                            int n42 = n3 * 8;
                            double[] dArray20 = bi$array;
                            int n43 = bi$offset + n42 / 8;
                            dArray19[n41] = d42 = dArray20[n43] / sum2;
                        }
                        ++n3;
                    }
                    break block44;
                }
                aa = 1.0;
                empal = nu + 1.0;
                double halfx = x$array[x$offset] * 0.5;
                if (nu != 0.0) {
                    double d43 = Mathlib.pow(halfx, nu);
                    double d44 = gamma_cody.Rf_gamma_cody(empal);
                    aa = d43 / d44;
                }
                if (ize$array[ize$offset] == 2) {
                    aa = Math.exp(-x$array[x$offset]) * aa;
                }
                double d45 = halfx;
                bb = d45 * d45;
                double[] dArray21 = bi$array;
                int n44 = bi$offset + 1;
                dArray21[n44] = d = aa * bb / empal + aa;
                if (x$array[x$offset] != 0.0 && (dArray = bi$array)[n2 = bi$offset + 1] == 0.0) {
                    ncalc$array[ncalc$offset] = 0;
                }
                if (nb$array[nb$offset] > 1) {
                    if (x$array[x$offset] == 0.0) {
                        n3 = 2;
                        while (nb$array[nb$offset] >= n3) {
                            int n45 = n3 * 8;
                            double[] dArray22 = bi$array;
                            int n46 = bi$offset + n45 / 8;
                            dArray22[n46] = 0.0;
                            ++n3;
                        }
                    } else {
                        cc = halfx;
                        double d46 = x$array[x$offset];
                        tover = 1.78E-307 / d46;
                        if (bb != 0.0) {
                            tover = 8.9E-308 / bb;
                        }
                        n3 = 2;
                        while (nb$array[nb$offset] >= n3) {
                            aa /= empal;
                            if (tover * (empal += 1.0) >= (aa *= cc)) {
                                int n47 = n3 * 8;
                                double[] dArray23 = bi$array;
                                int n48 = bi$offset + n47 / 8;
                                dArray23[n48] = aa = 0.0;
                            } else {
                                double d47;
                                int n49 = n3 * 8;
                                double[] dArray24 = bi$array;
                                int n50 = bi$offset + n49 / 8;
                                dArray24[n50] = d47 = aa * bb / empal + aa;
                            }
                            int n51 = n3 * 8;
                            double[] dArray25 = bi$array;
                            int n52 = bi$offset + n51 / 8;
                            if (dArray25[n52] == 0.0 && ncalc$array[ncalc$offset] > n3) {
                                int n53;
                                ncalc$array[ncalc$offset] = n53 = n3 + -1;
                            }
                            ++n3;
                        }
                    }
                }
                break block44;
            }
            ncalc$array[ncalc$offset] = n = Math.min(nb$array[nb$offset], 0) + -1;
        }
    }

    public static double bessel_i_ex(double d, double d2, double d3, DoublePtr doublePtr) {
        double d4;
        double[] bi$array = doublePtr.array;
        int bi$offset = doublePtr.offset;
        double[] x = new double[]{d};
        double[] alpha = new double[]{d2};
        int[] ize = new int[1];
        int[] ncalc = new int[1];
        int[] nb = new int[1];
        ncalc[0] = 0;
        if (Builtins.__isnan(x[0]) != 0 || Builtins.__isnan(alpha[0]) != 0) {
            double x$21 = x[0];
            double alpha$22 = alpha[0];
            d4 = x$21 + alpha$22;
        } else if (x[0] < 0.0) {
            byte[] msg = "\u0000".getBytes();
            int msg$offset = 0;
            msg = "value out of range in '%s'\n\u0000".getBytes();
            msg$offset = 0;
            Stdlib.printf(new BytePtr(msg, msg$offset), new BytePtr("bessel_i\u0000".getBytes(), 0));
            d4 = 0.0 / 0.0;
        } else {
            int ize$24;
            ize[0] = ize$24 = (int)d3;
            double na2 = Mathlib.floor(alpha[0]);
            if (alpha[0] < 0.0) {
                double iftmp$29;
                double d5 = -alpha[0];
                double d6 = bessel_i.bessel_i_ex(x[0], d5, d3, new DoublePtr(bi$array, bi$offset));
                if (alpha[0] != na2) {
                    double d7 = -alpha[0];
                    double d8 = bessel_k.bessel_k_ex(x[0], d7, d3, new DoublePtr(bi$array, bi$offset));
                    double iftmp$33 = ize[0] != 1 ? Math.exp(x[0] * -2.0) * 2.0 : 2.0;
                    double d9 = d8 * iftmp$33 / Math.PI;
                    double d10 = cospi.sinpi(-alpha[0]);
                    iftmp$29 = d9 * d10;
                } else {
                    iftmp$29 = 0.0;
                }
                d4 = d6 + iftmp$29;
            } else {
                double x$53;
                double alpha$40;
                int nb$37;
                nb[0] = nb$37 = (int)na2 + 1;
                double alpha$38 = alpha[0];
                double d11 = nb[0] + -1;
                alpha[0] = alpha$40 = alpha$38 - d11;
                bessel_i.I_bessel(new DoublePtr(x, 0), new DoublePtr(alpha, 0), new IntPtr(nb, 0), new IntPtr(ize, 0), new DoublePtr(bi$array, bi$offset), new IntPtr(ncalc, 0));
                int ncalc$41 = ncalc[0];
                int nb$42 = nb[0];
                if (ncalc$41 != nb$42) {
                    if (ncalc[0] < 0) {
                        double alpha$44 = alpha[0];
                        int nb$45 = nb[0];
                        int ncalc$46 = ncalc[0];
                        double x$47 = x[0];
                        Stdlib.printf(new BytePtr("bessel_i(%g): ncalc (=%d) != nb (=%d); alpha=%g. Arg. out of range?\n\u0000".getBytes(), 0), x$47, ncalc$46, nb$45, alpha$44);
                    } else {
                        double d12 = nb[0];
                        double alpha$49 = alpha[0];
                        double d13 = d12 + alpha$49 - 1.0;
                        double x$50 = x[0];
                        Stdlib.printf(new BytePtr("bessel_i(%g,nu=%g): precision lost in result\n\u0000".getBytes(), 0), x$50, d13);
                    }
                }
                int n = (nb[0] + -1) * 8;
                double[] dArray = bi$array;
                int n2 = bi$offset + n / 8;
                x[0] = x$53 = dArray[n2];
                d4 = x[0];
            }
        }
        return d4;
    }

    public static double bessel_i(double d, double d2, double d3) {
        double d4;
        double[] x = new double[]{d};
        double[] alpha = new double[]{d2};
        int[] ize = new int[1];
        int[] ncalc = new int[1];
        int[] nb = new int[1];
        ncalc[0] = 0;
        if (Builtins.__isnan(x[0]) != 0 || Builtins.__isnan(alpha[0]) != 0) {
            double x$56 = x[0];
            double alpha$57 = alpha[0];
            d4 = x$56 + alpha$57;
        } else if (x[0] < 0.0) {
            byte[] msg = "\u0000".getBytes();
            int msg$offset = 0;
            msg = "value out of range in '%s'\n\u0000".getBytes();
            msg$offset = 0;
            Stdlib.printf(new BytePtr(msg, msg$offset), new BytePtr("bessel_i\u0000".getBytes(), 0));
            d4 = 0.0 / 0.0;
        } else {
            int ize$59;
            ize[0] = ize$59 = (int)d3;
            double na2 = Mathlib.floor(alpha[0]);
            if (alpha[0] < 0.0) {
                double iftmp$64;
                double d5 = -alpha[0];
                double d6 = bessel_i.bessel_i(x[0], d5, d3);
                if (alpha[0] != na2) {
                    double d7 = -alpha[0];
                    double d8 = bessel_k.bessel_k(x[0], d7, d3);
                    double iftmp$68 = ize[0] != 1 ? Math.exp(x[0] * -2.0) * 2.0 : 2.0;
                    double d9 = d8 * iftmp$68 / Math.PI;
                    double d10 = cospi.sinpi(-alpha[0]);
                    iftmp$64 = d9 * d10;
                } else {
                    iftmp$64 = 0.0;
                }
                d4 = d6 + iftmp$64;
            } else {
                double x$90;
                double alpha$75;
                int nb$72;
                nb[0] = nb$72 = (int)na2 + 1;
                double alpha$73 = alpha[0];
                double d11 = nb[0] + -1;
                alpha[0] = alpha$75 = alpha$73 - d11;
                double[] bi = new double[Math.max(nb[0] * 8 / 8, 1)];
                int bi$offset = 0;
                bessel_i.I_bessel(new DoublePtr(x, 0), new DoublePtr(alpha, 0), new IntPtr(nb, 0), new IntPtr(ize, 0), new DoublePtr(bi, bi$offset), new IntPtr(ncalc, 0));
                int ncalc$78 = ncalc[0];
                int nb$79 = nb[0];
                if (ncalc$78 != nb$79) {
                    if (ncalc[0] < 0) {
                        double alpha$81 = alpha[0];
                        int nb$82 = nb[0];
                        int ncalc$83 = ncalc[0];
                        double x$84 = x[0];
                        Stdlib.printf(new BytePtr("bessel_i(%g): ncalc (=%d) != nb (=%d); alpha=%g. Arg. out of range?\n\u0000".getBytes(), 0), x$84, ncalc$83, nb$82, alpha$81);
                    } else {
                        double d12 = nb[0];
                        double alpha$86 = alpha[0];
                        double d13 = d12 + alpha$86 - 1.0;
                        double x$87 = x[0];
                        Stdlib.printf(new BytePtr("bessel_i(%g,nu=%g): precision lost in result\n\u0000".getBytes(), 0), x$87, d13);
                    }
                }
                int n = (nb[0] + -1) * 8;
                double[] dArray = bi;
                int n2 = bi$offset + n / 8;
                x[0] = x$90 = dArray[n2];
                d4 = x[0];
            }
        }
        return d4;
    }
}

