/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import java.util.List;
import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.primitives.combine.CombinedNames;
import org.renjin.primitives.combine.view.CombinedDoubleVector;
import org.renjin.primitives.combine.view.CombinedIntVector;
import org.renjin.primitives.combine.view.CombinedStringVector;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class LazyBuilder
implements CombinedBuilder {
    private final Vector.Type vectorType;
    private int elementCount;
    private boolean useNames;
    private List<Vector> vectors;
    private List<Vector> nameVectors;
    private boolean hasNames = false;

    public LazyBuilder(Vector.Type vectorType, int elementCount) {
        this.vectorType = vectorType;
        this.elementCount = elementCount;
        this.vectors = Lists.newArrayListWithCapacity(elementCount);
    }

    @Override
    public CombinedBuilder useNames(boolean useNames) {
        if (useNames) {
            this.useNames = true;
            this.nameVectors = Lists.newArrayListWithCapacity(this.elementCount);
        }
        return this;
    }

    @Override
    public void add(String prefix, SEXP sexp2) {
        throw new UnsupportedOperationException("LazyCombiner can only handle Vector inputs");
    }

    @Override
    public void addElements(String prefix, Vector vectorElement) {
        this.vectors.add(vectorElement);
        if (this.useNames) {
            this.nameVectors.add(CombinedNames.combine(prefix, vectorElement));
            if (CombinedNames.hasNames(prefix, vectorElement)) {
                this.hasNames = true;
            }
        }
    }

    @Override
    public Vector build() {
        Vector[] vectors = this.toArray(this.vectors);
        if (this.vectorType == IntVector.VECTOR_TYPE) {
            return CombinedIntVector.combine(vectors, this.buildAttributes());
        }
        if (this.vectorType == DoubleVector.VECTOR_TYPE) {
            return CombinedDoubleVector.combine(vectors, this.buildAttributes());
        }
        if (this.vectorType == StringVector.VECTOR_TYPE) {
            return CombinedStringVector.combine(vectors, this.buildAttributes());
        }
        throw new UnsupportedOperationException("vector type: " + this.vectorType);
    }

    private AttributeMap buildAttributes() {
        if (this.hasNames) {
            return new AttributeMap.Builder().setNames(CombinedStringVector.combine(this.nameVectors, AttributeMap.EMPTY)).build();
        }
        return AttributeMap.EMPTY;
    }

    private Vector[] toArray(List<Vector> list2) {
        return list2.toArray(new Vector[list2.size()]);
    }
}

