/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.asm.util;

import org.renjin.repackaged.asm.AnnotationVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.util.CheckMethodAdapter;

public class CheckAnnotationAdapter
extends AnnotationVisitor {
    private final boolean named;
    private boolean end;

    public CheckAnnotationAdapter(AnnotationVisitor annotationVisitor) {
        this(annotationVisitor, true);
    }

    CheckAnnotationAdapter(AnnotationVisitor annotationVisitor, boolean bl) {
        super(327680, annotationVisitor);
        this.named = bl;
    }

    public void visit(String string, Object object2) {
        int n;
        this.checkEnd();
        this.checkName(string);
        if (!(object2 instanceof Byte || object2 instanceof Boolean || object2 instanceof Character || object2 instanceof Short || object2 instanceof Integer || object2 instanceof Long || object2 instanceof Float || object2 instanceof Double || object2 instanceof String || object2 instanceof Type || object2 instanceof byte[] || object2 instanceof boolean[] || object2 instanceof char[] || object2 instanceof short[] || object2 instanceof int[] || object2 instanceof long[] || object2 instanceof float[] || object2 instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (object2 instanceof Type && (n = ((Type)object2).getSort()) == 11) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (this.av != null) {
            this.av.visit(string, object2);
        }
    }

    public void visitEnum(String string, String string2, String string3) {
        this.checkEnd();
        this.checkName(string);
        CheckMethodAdapter.checkDesc(string2, false);
        if (string3 == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        if (this.av != null) {
            this.av.visitEnum(string, string2, string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        this.checkEnd();
        this.checkName(string);
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitAnnotation(string, string2));
    }

    public AnnotationVisitor visitArray(String string) {
        this.checkEnd();
        this.checkName(string);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitArray(string), false);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    private void checkName(String string) {
        if (this.named && string == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }
}

