/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class URLFileNameParser
extends HostFileNameParser {
    public URLFileNameParser(int defaultPort) {
        super(defaultPort);
    }

    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch) || ch == '?';
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        HostFileNameParser.Authority auth = this.extractToPath(filename, name);
        String queryString = UriParser.extractQueryString(name);
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path2 = name.toString();
        return new URLFileName(auth.getScheme(), auth.getHostName(), auth.getPort(), this.getDefaultPort(), auth.getUserName(), auth.getPassword(), path2, fileType, queryString);
    }
}

