/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import org.renjin.eval.EvalException;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class ArgumentMatching {
    public int[] match(Symbol[] formalNames, String[] actualNames) {
        int i;
        boolean[] actualMatched = new boolean[actualNames.length];
        boolean[] formalMatched = new boolean[formalNames.length];
        int[] match2 = new int[actualMatched.length];
        for (i = 0; i < formalNames.length; ++i) {
            int exactMatch;
            Symbol formal = formalNames[i];
            if (formal == Symbols.ELLIPSES || (exactMatch = this.findExactMatch(formal, actualNames)) == -1) continue;
            formalMatched[i] = true;
            actualMatched[exactMatch] = true;
            match2[exactMatch] = i;
        }
        for (i = 0; i < actualNames.length; ++i) {
            int partialMatch;
            String actualName;
            if (actualMatched[i] || (actualName = actualNames[i]) == null || (partialMatch = this.findPartialMatch(actualNames[i], formalNames)) == -1) continue;
            match2[i] = partialMatch;
            formalMatched[partialMatch] = true;
            actualMatched[i] = true;
        }
        throw new UnsupportedOperationException("TODO");
    }

    private int nextUnmatched(boolean[] matched, int start) {
        for (int i = start; i < matched.length; ++i) {
            if (matched[i]) continue;
            return i;
        }
        return -1;
    }

    private int findExactMatch(Symbol formal, String[] actualNames) {
        String formalName = formal.getPrintName();
        int exactMatch = -1;
        for (int i = 0; i < actualNames.length; ++i) {
            String actualName = actualNames[i];
            if (actualName == null || !actualName.equals(formalName)) continue;
            if (exactMatch == -1) {
                exactMatch = i;
                continue;
            }
            throw new EvalException(String.format("Multiple named values provided for argument '%s'", formal.getPrintName()), new Object[0]);
        }
        return exactMatch;
    }

    private int findPartialMatch(String actualName, Symbol[] formalNames) {
        Symbol formalName;
        int partialMatch = -1;
        for (int i = 0; i < formalNames.length && (formalName = formalNames[i]) != Symbols.ELLIPSES; ++i) {
            if (!formalName.getPrintName().startsWith(actualName)) continue;
            if (partialMatch == -1) {
                partialMatch = i;
                continue;
            }
            throw new EvalException(String.format("Provided argument '%s' matches multiple named formal arguments", actualName), new Object[0]);
        }
        return partialMatch;
    }
}

