/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.eval.Session;
import org.renjin.primitives.packaging.ClasspathPackageLoader;
import org.renjin.primitives.packaging.PackageLoader;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Symbol;
import org.renjin.util.FileSystemUtils;

public class SessionBuilder {
    private boolean loadBasePackage = true;
    private Map<Class, Object> bindings = Maps.newHashMap();
    private List<String> packagesToLoad = Lists.newArrayList();

    public SessionBuilder() {
        this.bind(PackageLoader.class, new ClasspathPackageLoader());
    }

    public SessionBuilder withFileSystemManager(FileSystemManager fsm) {
        this.bindings.put(FileSystemManager.class, fsm);
        return this;
    }

    public SessionBuilder withoutBasePackage() {
        this.loadBasePackage = false;
        return this;
    }

    public SessionBuilder withDefaultPackages() {
        this.packagesToLoad = Session.DEFAULT_PACKAGES;
        return this;
    }

    public <T> SessionBuilder bind(Class<T> clazz, T instance) {
        this.bindings.put(clazz, instance);
        return this;
    }

    public Session build() {
        try {
            if (!this.bindings.containsKey(FileSystemManager.class)) {
                this.bindings.put(FileSystemManager.class, FileSystemUtils.getMinimalFileSystemManager());
            }
            Session session = new Session(this.bindings);
            if (this.loadBasePackage) {
                session.getTopLevelContext().init();
            }
            for (String packageToLoad : this.packagesToLoad) {
                session.getTopLevelContext().evaluate(FunctionCall.newCall(Symbol.get("library"), Symbol.get(packageToLoad)));
            }
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Session buildDefault() {
        return new SessionBuilder().build();
    }
}

