/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.DoublePtr;

public class chebyshev {
    private chebyshev() {
    }

    public static double Rf_chebyshev_eval(double d, DoublePtr doublePtr, int n) {
        double d2;
        double[] a$array = doublePtr.array;
        int a$offset = doublePtr.offset;
        double twox = 0.0;
        if (n <= 0 || n > 1000) {
            d2 = 0.0 / 0.0;
        } else if (d < -1.1 || d > 1.1) {
            d2 = 0.0 / 0.0;
        } else {
            double b1;
            twox = d * 2.0;
            double b2 = b1 = 0.0;
            double b0 = 0.0;
            int i = 1;
            while (i <= n) {
                b2 = b1;
                b1 = b0;
                double d3 = twox * b1 - b2;
                int n2 = (n - i) * 8;
                double[] dArray = a$array;
                int n3 = a$offset + n2 / 8;
                double d4 = dArray[n3];
                b0 = d3 + d4;
                ++i;
            }
            d2 = (b0 - b2) * 0.5;
        }
        return d2;
    }

    public static int Rf_chebyshev_init(DoublePtr doublePtr, int n, double d) {
        int n2;
        block4: {
            double[] dos$array = doublePtr.array;
            int dos$offset = doublePtr.offset;
            if (n <= 0) {
                n2 = 0;
            } else {
                double err = 0.0;
                int i = 0;
                int ii = 1;
                while (ii <= n) {
                    double[] dArray = dos$array;
                    i = n - ii;
                    int n3 = i * 8;
                    int n4 = dos$offset + n3 / 8;
                    err = Math.abs(dArray[n4]) + err;
                    if (err > d) {
                        n2 = i;
                        break block4;
                    }
                    ++ii;
                }
                n2 = i;
            }
        }
        return n2;
    }
}

