/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Vectors;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.sequence.RepIntVector;
import org.renjin.primitives.sequence.RepLogicalVector;
import org.renjin.primitives.sequence.RepStringVector;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class CompleteSelection
implements SelectionStrategy {
    CompleteSelection() {
    }

    @Override
    public SEXP getVectorSubset(Context context, Vector source, boolean drop2) {
        return source;
    }

    @Override
    public SEXP getSingleListElement(ListVector source, boolean exact) {
        throw new EvalException("[[ operator requires a subscript", new Object[0]);
    }

    @Override
    public AtomicVector getSingleAtomicVectorElement(AtomicVector source, boolean exact) {
        throw new EvalException("[[ operator requires a subscript", new Object[0]);
    }

    @Override
    public Vector replaceAtomicVectorElements(Context context, AtomicVector source, Vector replacements) {
        Vector result = this.recycle(replacements, source.length());
        if (source.getVectorType().isWiderThan(replacements.getVectorType())) {
            result = Vectors.toType((AtomicVector)result, source.getVectorType());
        }
        return (Vector)result.setAttributes(source.getAttributes());
    }

    private Vector recycle(Vector x, int length2) {
        if (x.length() == length2) {
            return x;
        }
        if (x.isDeferred() || length2 > 100) {
            if (x instanceof DoubleVector) {
                return new RepDoubleVector(x, length2, 1, AttributeMap.EMPTY);
            }
            if (x instanceof IntVector) {
                return new RepIntVector(x, length2, 1, AttributeMap.EMPTY);
            }
            if (x instanceof StringVector) {
                return new RepStringVector(x, length2, 1, AttributeMap.EMPTY);
            }
            if (x instanceof LogicalVector) {
                return new RepLogicalVector(x, length2, 1, AttributeMap.EMPTY);
            }
        }
        Vector.Builder builder = x.newBuilderWithInitialCapacity(length2);
        for (int i = 0; i < length2; ++i) {
            builder.setFrom(i, x, i % x.length());
        }
        return builder.build();
    }

    @Override
    public ListVector replaceListElements(Context context, ListVector source, Vector replacement) {
        if (replacement == Null.INSTANCE) {
            return this.clearList(source);
        }
        if (replacement.length() == 0) {
            throw new EvalException("replacement has length zero", new Object[0]);
        }
        ListVector.Builder result = new ListVector.Builder();
        result.copyAttributesFrom(source);
        int replacementIndex = 0;
        for (int i = 0; i < source.length(); ++i) {
            result.setFrom(i, replacement, replacementIndex++);
            if (replacementIndex < replacement.length()) continue;
            replacementIndex = 0;
        }
        return result.build();
    }

    private ListVector clearList(ListVector list2) {
        AttributeMap.Builder builder = new AttributeMap.Builder();
        for (Symbol attribute : list2.getAttributes().names()) {
            if (attribute == Symbols.NAMES || attribute == Symbols.DIM || attribute == Symbols.DIMNAMES) continue;
            builder.set(attribute, list2.getAttribute(attribute));
        }
        return new ListVector(new SEXP[0], builder.validateAndBuildForVectorOfLength(0));
    }

    private void checkReplacementLength(Vector source, SEXP replacements) {
        if (source.length() % replacements.length() != 0) {
            throw new EvalException("number of items to replace is not a multiple of replacement length", new Object[0]);
        }
    }

    @Override
    public Vector replaceSingleElement(AtomicVector source, Vector replacement) {
        throw new EvalException("[[ ]] with missing subscript", new Object[0]);
    }

    @Override
    public ListVector replaceSingleListElement(ListVector list2, SEXP replacement) {
        throw new EvalException("[[ ]] with missing subscript", new Object[0]);
    }

    @Override
    public SEXP replaceSinglePairListElement(PairList.Node list2, SEXP replacement) {
        throw new EvalException("[[ ]] with missing subscript", new Object[0]);
    }
}

