/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class TarBuffer {
    public static final int DEFAULT_RECORDSIZE = 512;
    public static final int DEFAULT_BLOCKSIZE = 10240;
    private byte[] blockBuffer;
    private int blockSize;
    private int currBlkIdx;
    private int currRecIdx;
    private boolean debug;
    private InputStream input;
    private OutputStream output;
    private int recordSize;
    private int recsPerBlock;

    TarBuffer(InputStream input) {
        this(input, 10240);
    }

    TarBuffer(InputStream input, int blockSize) {
        this(input, blockSize, 512);
    }

    TarBuffer(InputStream input, int blockSize, int recordSize) {
        this.input = input;
        this.initialize(blockSize, recordSize);
    }

    TarBuffer(OutputStream output) {
        this(output, 10240);
    }

    TarBuffer(OutputStream output, int blockSize) {
        this(output, blockSize, 512);
    }

    TarBuffer(OutputStream output, int blockSize, int recordSize) {
        this.output = output;
        this.initialize(blockSize, recordSize);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getCurrentBlockNum() {
        return this.currBlkIdx;
    }

    public int getCurrentRecordNum() {
        return this.currRecIdx - 1;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public boolean isEOFRecord(byte[] record2) {
        int size = this.getRecordSize();
        for (int i = 0; i < size; ++i) {
            if (record2[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        if (this.debug) {
            this.debug("TarBuffer.closeBuffer().");
        }
        if (null != this.output) {
            this.flushBlock();
            if (this.output != System.out && this.output != System.err) {
                this.output.close();
                this.output = null;
            }
        } else if (this.input != null && this.input != System.in) {
            this.input.close();
            this.input = null;
        }
    }

    public byte[] readRecord() throws IOException {
        String message;
        if (this.debug) {
            message = "ReadRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug(message);
        }
        if (null == this.input) {
            message = "reading from an output buffer";
            throw new IOException("reading from an output buffer");
        }
        if (this.currRecIdx >= this.recsPerBlock && !this.readBlock()) {
            return null;
        }
        byte[] result = new byte[this.recordSize];
        System.arraycopy(this.blockBuffer, this.currRecIdx * this.recordSize, result, 0, this.recordSize);
        ++this.currRecIdx;
        return result;
    }

    public void skipRecord() throws IOException {
        String message;
        if (this.debug) {
            message = "SkipRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug(message);
        }
        if (null == this.input) {
            message = "reading (via skip) from an output buffer";
            throw new IOException("reading (via skip) from an output buffer");
        }
        if (this.currRecIdx >= this.recsPerBlock && !this.readBlock()) {
            return;
        }
        ++this.currRecIdx;
    }

    public void writeRecord(byte[] record2) throws IOException {
        String message;
        if (this.debug) {
            message = "WriteRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug(message);
        }
        if (null == this.output) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        if (record2.length != this.recordSize) {
            message = "record to write has length '" + record2.length + "' which is not the record size of '" + this.recordSize + "'";
            throw new IOException(message);
        }
        if (this.currRecIdx >= this.recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(record2, 0, this.blockBuffer, this.currRecIdx * this.recordSize, this.recordSize);
        ++this.currRecIdx;
    }

    public void writeRecord(byte[] buffer, int offset) throws IOException {
        String message;
        if (this.debug) {
            message = "WriteRecord: recIdx = " + this.currRecIdx + " blkIdx = " + this.currBlkIdx;
            this.debug(message);
        }
        if (null == this.output) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        if (offset + this.recordSize > buffer.length) {
            message = "record has length '" + buffer.length + "' with offset '" + offset + "' which is less than the record size of '" + this.recordSize + "'";
            throw new IOException(message);
        }
        if (this.currRecIdx >= this.recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(buffer, offset, this.blockBuffer, this.currRecIdx * this.recordSize, this.recordSize);
        ++this.currRecIdx;
    }

    private void flushBlock() throws IOException {
        String message;
        if (this.debug) {
            message = "TarBuffer.flushBlock() called.";
            this.debug("TarBuffer.flushBlock() called.");
        }
        if (this.output == null) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        if (this.currRecIdx > 0) {
            this.writeBlock();
        }
    }

    private void initialize(int blockSize, int recordSize) {
        this.debug = false;
        this.blockSize = blockSize;
        this.recordSize = recordSize;
        this.recsPerBlock = this.blockSize / this.recordSize;
        this.blockBuffer = new byte[this.blockSize];
        if (null != this.input) {
            this.currBlkIdx = -1;
            this.currRecIdx = this.recsPerBlock;
        } else {
            this.currBlkIdx = 0;
            this.currRecIdx = 0;
        }
    }

    private boolean readBlock() throws IOException {
        String message;
        if (this.debug) {
            message = "ReadBlock: blkIdx = " + this.currBlkIdx;
            this.debug(message);
        }
        if (null == this.input) {
            message = "reading from an output buffer";
            throw new IOException("reading from an output buffer");
        }
        this.currRecIdx = 0;
        int offset = 0;
        int bytesNeeded = this.blockSize;
        while (bytesNeeded > 0) {
            long numBytes = this.input.read(this.blockBuffer, offset, bytesNeeded);
            if (numBytes == -1L) {
                Arrays.fill(this.blockBuffer, offset, offset + bytesNeeded, (byte)0);
                break;
            }
            offset = (int)((long)offset + numBytes);
            bytesNeeded = (int)((long)bytesNeeded - numBytes);
            if (numBytes == (long)this.blockSize || !this.debug) continue;
            System.err.println("ReadBlock: INCOMPLETE READ " + numBytes + " of " + this.blockSize + " bytes read.");
        }
        ++this.currBlkIdx;
        return true;
    }

    private void writeBlock() throws IOException {
        String message;
        if (this.debug) {
            message = "WriteBlock: blkIdx = " + this.currBlkIdx;
            this.debug(message);
        }
        if (null == this.output) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        this.output.write(this.blockBuffer, 0, this.blockSize);
        this.output.flush();
        this.currRecIdx = 0;
        ++this.currBlkIdx;
    }

    protected void debug(String message) {
        if (this.debug) {
            System.err.println(message);
        }
    }
}

