/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.remove;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnRemoveConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private List removedFiles = new ArrayList();

    public SvnRemoveConsumer(ScmLogger logger) {
        this.logger = logger;
    }

    public void consumeLine(String line) {
        if (line.length() <= 3) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected input, the line must be at least three characters long. Line: '" + line + "'.");
            }
            return;
        }
        String statusString = line.substring(0, 1);
        String file2 = line.substring(3);
        if (!statusString.equals("D")) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Unknown file status: '" + statusString + "'.");
            }
            return;
        }
        ScmFileStatus status = ScmFileStatus.DELETED;
        this.removedFiles.add(new ScmFile(file2, status));
    }

    public List getRemovedFiles() {
        return this.removedFiles;
    }
}

