/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ConstantCall;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;

public class StaticMethodCall
implements Specialization {
    private final JvmMethod method;
    private final ValueBounds valueBounds;
    private final boolean pure;

    public StaticMethodCall(JvmMethod method) {
        this.method = method;
        this.pure = method.isPure();
        this.valueBounds = ValueBounds.of(method.getReturnType());
    }

    public Specialization furtherSpecialize(List<ValueBounds> argumentBounds) {
        if (this.pure && ValueBounds.allConstant(argumentBounds)) {
            return ConstantCall.evaluate(this.method, argumentBounds);
        }
        return this;
    }

    @Override
    public Type getType() {
        return Type.getType(this.method.getReturnType());
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        for (JvmMethod.Argument argument : this.method.getAllArguments()) {
            if (argument.isContextual()) {
                throw new UnsupportedOperationException("TODO");
            }
            Expression argumentExpr = arguments.get(argument.getIndex()).getExpression();
            argumentExpr.load(emitContext, mv);
            emitContext.convert(mv, argumentExpr.getType(), Type.getType(argument.getClazz()));
        }
        mv.invokestatic(Type.getInternalName(this.method.getDeclaringClass()), this.method.getName(), Type.getMethodDescriptor(this.method.getMethod()), false);
    }
}

