/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.sexp.Vector;

public class BinaryVectorOpAccessor
extends Accessor {
    private Accessor[] operandAccessors = new Accessor[2];
    private int lengthLocal1;
    private int lengthLocal2;
    private int lengthLocal;
    private Method applyMethod;
    private Class<?> operandType;

    public BinaryVectorOpAccessor(DeferredNode node, InputGraph inputGraph) {
        this.operandAccessors[0] = Accessors.create(node.getOperands().get(0), inputGraph);
        this.operandAccessors[1] = Accessors.create(node.getOperands().get(1), inputGraph);
        this.applyMethod = BinaryVectorOpAccessor.findStaticApply(node.getVector());
        assert (this.applyMethod != null);
        this.operandType = this.applyMethod.getParameterTypes()[0];
    }

    public static boolean accept(DeferredNode node) {
        return BinaryVectorOpAccessor.findStaticApply(node.getVector()) != null;
    }

    private static Method findStaticApply(Vector vector2) {
        for (Method method : vector2.getClass().getMethods()) {
            if (!method.getName().equals("compute") || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 2 || !BinaryVectorOpAccessor.supportedType(method.getReturnType()) || !BinaryVectorOpAccessor.supportedType(method.getParameterTypes()[0]) || !method.getParameterTypes()[0].equals(method.getParameterTypes()[1])) continue;
            return method;
        }
        return null;
    }

    @Override
    public void init(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        this.operandAccessors[0].init(method);
        this.operandAccessors[1].init(method);
        this.lengthLocal1 = method.reserveLocal(1);
        this.lengthLocal2 = method.reserveLocal(1);
        this.lengthLocal = method.reserveLocal(1);
        this.operandAccessors[0].pushLength(method);
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.lengthLocal1);
        this.operandAccessors[1].pushLength(method);
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.lengthLocal2);
        method.getVisitor().visitMethodInsn(184, "java/lang/Math", "max", "(II)I", false);
        mv.visitVarInsn(54, this.lengthLocal);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        method.getVisitor().visitVarInsn(21, this.lengthLocal);
    }

    private void pushDoubleArguments(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(21, this.lengthLocal1);
        mv.visitInsn(112);
        this.operandAccessors[0].pushDouble(method);
        mv.visitInsn(93);
        mv.visitInsn(88);
        mv.visitVarInsn(21, this.lengthLocal2);
        mv.visitInsn(112);
        this.operandAccessors[1].pushDouble(method);
    }

    private void pushIntArguments(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(21, this.lengthLocal1);
        mv.visitInsn(112);
        this.operandAccessors[0].pushInt(method);
        mv.visitInsn(95);
        mv.visitVarInsn(21, this.lengthLocal2);
        mv.visitInsn(112);
        this.operandAccessors[1].pushInt(method);
    }

    private void pushComputation(ComputeMethod method) {
        if (this.operandType.equals(Double.TYPE)) {
            this.pushDoubleArguments(method);
        } else if (this.operandType.equals(Integer.TYPE)) {
            this.pushIntArguments(method);
        } else {
            throw new IllegalStateException("operandType: " + this.operandType);
        }
        method.getVisitor().visitMethodInsn(184, Type.getInternalName(this.applyMethod.getDeclaringClass()), this.applyMethod.getName(), Type.getMethodDescriptor(this.applyMethod), false);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        this.pushComputation(method);
        if (this.applyMethod.getReturnType().equals(Integer.TYPE)) {
            method.getVisitor().visitInsn(135);
        } else if (!this.applyMethod.getReturnType().equals(Double.TYPE)) {
            throw new UnsupportedOperationException("returnType: " + this.applyMethod.getReturnType());
        }
    }

    @Override
    public void pushInt(ComputeMethod method) {
        this.pushComputation(method);
        if (!this.applyMethod.getReturnType().equals(Integer.TYPE)) {
            if (this.applyMethod.getReturnType().equals(Double.TYPE)) {
                method.getVisitor().visitInsn(142);
            } else {
                throw new UnsupportedOperationException("returnType: " + this.applyMethod.getReturnType());
            }
        }
    }
}

