/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.Ptr;

public final class VoidPtr {
    private VoidPtr() {
    }

    public static int memcmp(Object x, Object y, int numBytes) {
        if (x instanceof DoublePtr && y instanceof DoublePtr) {
            return DoublePtr.memcmp((DoublePtr)x, (DoublePtr)y, numBytes);
        }
        if (x instanceof LongPtr && y instanceof LongPtr) {
            return LongPtr.memcmp((LongPtr)x, (LongPtr)y, numBytes);
        }
        if (x instanceof IntPtr && y instanceof IntPtr) {
            return IntPtr.memcmp((IntPtr)x, (IntPtr)y, numBytes);
        }
        throw new UnsupportedOperationException("Not implemented: memcmp(" + x.getClass().getName() + ", " + y.getClass().getName() + ", n)");
    }

    public static Object pointerPlus(Object p, int bytes) {
        if (p instanceof Ptr) {
            return ((Ptr)p).pointerPlus(bytes);
        }
        throw new UnsupportedOperationException("TODO");
    }

    public static void memcpy(Object x, Object y, int numBytes) {
        throw new UnsupportedOperationException("TODO: Implement VoidPtr.memcpy");
    }

    public static void memset(Object p, int value, int length2) {
        if (p instanceof DoublePtr) {
            DoublePtr pd = (DoublePtr)p;
            DoublePtr.memset(pd.array, pd.offset, value, length2);
        } else if (p instanceof BytePtr) {
            BytePtr pb = (BytePtr)p;
            BytePtr.memset(pb.array, pb.offset, value, length2);
        } else if (p instanceof CharPtr) {
            CharPtr pc = (CharPtr)p;
            CharPtr.memset(pc.array, pc.offset, value, length2);
        } else if (p instanceof ObjectPtr) {
            ObjectPtr po = (ObjectPtr)p;
            ObjectPtr.memset(po.array, po.offset, value, length2);
        } else {
            throw new UnsupportedOperationException("TODO: p instanceof " + p.getClass().getName());
        }
    }

    public static int compare(Object x, Object y) {
        if (x instanceof Ptr && y instanceof Ptr) {
            Ptr px = (Ptr)x;
            Ptr py = (Ptr)y;
            if (px.getArray() == py.getArray()) {
                return Integer.compare(px.getOffset(), py.getOffset());
            }
        }
        return Integer.compare(System.identityHashCode(x), System.identityHashCode(y));
    }

    public static void assign(Object[] array2, int offset, Object value) throws NoSuchMethodException {
        if (value instanceof MallocThunk && !array2.getClass().equals(Object[].class)) {
            ((MallocThunk)value).assign(array2, offset);
        } else {
            try {
                array2[offset] = value;
            }
            catch (ArrayStoreException e) {
                throw new IllegalStateException("Exception storing value of class " + value.getClass().getName() + " to array of class " + array2.getClass().getName());
            }
        }
    }
}

