/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gnur.api.GnuCharSexp;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.StringVector;

public class GnuStringVector
extends StringVector {
    private BytePtr[] values;

    public GnuStringVector(String string) {
        this(BytePtr.nullTerminatedString(string, Charsets.UTF_8));
    }

    public GnuStringVector(BytePtr ... values) {
        this(values, AttributeMap.EMPTY);
    }

    public GnuStringVector(BytePtr[] values, AttributeMap attributes2) {
        super(attributes2);
        this.values = values;
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new GnuStringVector(this.values, attributes2);
    }

    @Override
    public String getElementAsString(int index) {
        BytePtr value = this.values[index];
        if (value == null) {
            return null;
        }
        return value.nullTerminatedString();
    }

    @Override
    public boolean isElementNA(int index) {
        return this.values[index] == null;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    public void set(int index, GnuCharSexp charValue) {
        this.values[index] = charValue.getValue();
    }
}

