/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dbeta;
import org.renjin.nmath.dpois;

public class dnbeta {
    public static double $dnbeta$eps = 1.0E-15;

    private dnbeta() {
    }

    public static double dnbeta(double d, double d2, double d3, double d4, int n) {
        double d5;
        double p_k = 0.0;
        double dx2 = 0.0;
        int kMax = 0;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0 || Builtins.__isnan(d4) != 0) {
            d5 = d + d2 + d3 + d4;
        } else if (d4 < 0.0 || d2 <= 0.0 || d3 <= 0.0) {
            d5 = 0.0 / 0.0;
        } else if (Builtins.__finite(d2) == 0 || Builtins.__finite(d3) == 0 || Builtins.__finite(d4) == 0) {
            d5 = 0.0 / 0.0;
        } else if (d < 0.0 || d > 1.0) {
            double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
            d5 = iftmp$0;
        } else if (d4 == 0.0) {
            d5 = dbeta.dbeta(d, d2, d3, n);
        } else {
            double d6;
            double ncp2 = d4 * 0.5;
            dx2 = ncp2 * d;
            double d7 = d6 = (dx2 - d2 - 1.0) / 2.0;
            double d8 = d7 * d7;
            double d9 = (d2 + d3) * dx2;
            double D = d8 + d9 - d2;
            if (D <= 0.0) {
                kMax = 0;
            } else {
                D = Mathlib.ceil(Mathlib.sqrt(D) + d6);
                int iftmp$1 = D > 0.0 ? (int)D : 0;
                kMax = iftmp$1;
            }
            double d10 = (double)kMax + d2;
            double term = dbeta.dbeta(d, d10, d3, 1);
            p_k = dpois.dpois_raw(kMax, ncp2, 1);
            if (d == 0.0 || Builtins.__finite(term) == 0 || Builtins.__finite(p_k) == 0) {
                double iftmp$2 = n != 0 ? p_k + term : Math.exp(p_k + term);
                d5 = iftmp$2;
            } else {
                double eps$4;
                double q;
                double eps$3;
                p_k += term;
                double sum2 = term = 1.0;
                double k = kMax;
                while (k > 0.0 && sum2 * (eps$3 = $dnbeta$eps) < term) {
                    double d11 = (k -= 1.0) + 1.0;
                    double d12 = k + d2;
                    double d13 = d11 * d12;
                    double d14 = k + d2 + d3;
                    q = d13 / d14 / dx2;
                    sum2 += (term *= q);
                }
                term = 1.0;
                k = kMax;
                do {
                    double d15 = (k + d2 + d3) * dx2;
                    double d16 = k + d2;
                    double d17 = d15 / d16;
                    double d18 = k + 1.0;
                    q = d17 / d18;
                    k += 1.0;
                } while ((sum2 += (term *= q)) * (eps$4 = $dnbeta$eps) < term);
                double iftmp$5 = n != 0 ? Math.log(sum2) + p_k : Math.exp(Math.log(sum2) + p_k);
                d5 = iftmp$5;
            }
        }
        return d5;
    }
}

