/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.fmin2;
import org.renjin.nmath.pbinom;
import org.renjin.nmath.qnorm;

public class qbinom {
    private qbinom() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qbinom(double d, double d2, double d3, int n, int n2) {
        double oldincr;
        double z$11;
        double z$7;
        double[] z = new double[]{0.0};
        if (Builtins.__isnan(d) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d3) != 0) return d + d2 + d3;
        if (Builtins.__finite(d2) == 0) return 0.0 / 0.0;
        if (Builtins.__finite(d3) == 0) return 0.0 / 0.0;
        if (Builtins.__finite(d) == 0) {
            if (n2 == 0) return 0.0 / 0.0;
        }
        if (Mathlib.floor(d2 + 0.5) != d2) return 0.0 / 0.0;
        if (d3 < 0.0) return 0.0 / 0.0;
        if (d3 > 1.0) return 0.0 / 0.0;
        if (d2 < 0.0) return 0.0 / 0.0;
        if (n2 != 0) {
            if (d > 0.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$0 = d2;
                return iftmp$0;
            }
            double d4 = -1.0 / 0.0;
            if (d == d4) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$1 = d2;
                return iftmp$1;
            }
        } else {
            if (d < 0.0) return 0.0 / 0.0;
            if (d > 1.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$2 = d2;
                return iftmp$2;
            }
            if (d == 1.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$3 = d2;
                return iftmp$3;
            }
        }
        if (d3 == 0.0) return 0.0;
        if (d2 == 0.0) return 0.0;
        double q = 1.0 - d3;
        if (q == 0.0) return d2;
        double mu = d2 * d3;
        double sigma = Mathlib.sqrt(d2 * d3 * q);
        double gamma2 = (q - d3) / sigma;
        if (n == 0 || n2 != 0) {
            double iftmp$4;
            if (n2 != 0) {
                double iftmp$5 = n != 0 ? Math.exp(d) : -Mathlib.expm1(d);
                iftmp$4 = iftmp$5;
            } else {
                double iftmp$6 = n == 0 ? 0.5 - d + 0.5 : d;
                iftmp$4 = iftmp$6;
            }
            d = iftmp$4;
            if (d == 0.0) return 0.0;
            if (d == 1.0) return d2;
        }
        if (d + 2.242650509742816E-16 >= 1.0) return d2;
        z[0] = z$7 = qnorm.qnorm5(d, 0.0, 1.0, 1, 0);
        double z$8 = z[0];
        double z$9 = z[0];
        double d5 = (z$8 * z$9 - 1.0) * gamma2 / 6.0;
        double z$10 = z[0];
        double y = Mathlib.floor((d5 + z$10) * sigma + mu + 0.5);
        if (y > d2) {
            y = d2;
        }
        z[0] = z$11 = pbinom.pbinom(y, d2, d3, 1, 0);
        d *= 0.9999999999999858;
        if (d2 < 100000.0) return qbinom.do_search(y, new DoublePtr(z, 0), d, d2, d3, 1.0);
        double incr = Mathlib.floor(d2 * 0.001);
        do {
            oldincr = incr;
            y = qbinom.do_search(y, new DoublePtr(z, 0), d, d2, d3, incr);
            double d6 = Mathlib.floor(incr / 100.0);
            incr = fmax2.fmax2(1.0, d6);
        } while (oldincr > 1.0 && d2 * 1.0E-15 < incr);
        return y;
    }

    public static double do_search(double d, DoublePtr doublePtr, double d2, double d3, double d4, double d5) {
        double d6;
        block4: {
            double[] z$array = doublePtr.array;
            int z$offset = doublePtr.offset;
            if (z$array[z$offset] >= d2) {
                while (true) {
                    double newz;
                    if (d == 0.0 || (newz = pbinom.pbinom(d - d5, d3, d4, 1, 0)) < d2) {
                        d6 = d;
                        break block4;
                    }
                    double d7 = d - d5;
                    d = fmax2.fmax2(0.0, d7);
                    z$array[z$offset] = newz;
                }
            }
            while ((d = fmin2.fmin2(d + d5, d3)) != d3) {
                double d8;
                z$array[z$offset] = d8 = pbinom.pbinom(d, d3, d4, 1, 0);
                if (!(z$array[z$offset] >= d2)) continue;
            }
            d6 = d;
        }
        return d6;
    }
}

