/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.serialization;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.Context;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.Primitives;
import org.renjin.primitives.io.serialization.Flags;
import org.renjin.primitives.io.serialization.NullReadContext;
import org.renjin.primitives.io.serialization.ReadContext;
import org.renjin.primitives.io.serialization.SessionReadContext;
import org.renjin.primitives.io.serialization.Version;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.primitives.vector.ConvertingStringVector;
import org.renjin.primitives.vector.RowNamesVector;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.io.ByteSource;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.CHARSEXP;
import org.renjin.sexp.Closure;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntBufferVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class RDataReader
implements AutoCloseable {
    private InputStream conn;
    private StreamReader in;
    private int version;
    private Version writerVersion;
    private Version releaseVersion;
    private List<SEXP> referenceTable = Lists.newArrayList();
    private PersistentRestorer restorer;
    private ReadContext readContext;

    public RDataReader(Context context, InputStream conn) {
        this.readContext = new SessionReadContext(context.getSession());
        this.conn = conn;
    }

    public RDataReader(Context context, Environment rho, InputStream conn, PersistentRestorer restorer) {
        this(context, conn);
        this.restorer = restorer;
    }

    public RDataReader(InputStream conn) {
        this.readContext = new NullReadContext();
        this.conn = conn;
    }

    public SEXP readFile() throws IOException {
        byte streamType = RDataReader.readStreamType(this.conn);
        this.in = RDataReader.createStreamReader(streamType, this.conn);
        this.readAndVerifyVersion();
        return this.readExp();
    }

    protected void readAndVerifyVersion() throws IOException {
        this.version = this.in.readInt();
        this.writerVersion = new Version(this.in.readInt());
        this.releaseVersion = new Version(this.in.readInt());
        if (this.version != 2) {
            if (this.releaseVersion.isExperimental()) {
                throw new IOException(String.format("cannot read unreleased workspace version %d written by experimental R %s", this.version, this.writerVersion));
            }
            throw new IOException(String.format("cannot read workspace version %d written by R %s; need R %s or newer", this.version, this.releaseVersion, this.releaseVersion));
        }
    }

    public static boolean isRDataFile(ByteSource inputSupplier) throws IOException {
        try (InputStream in = inputSupplier.openStream();){
            byte streamType = RDataReader.readStreamType(in);
            boolean bl = streamType != -1;
            return bl;
        }
    }

    public static byte readStreamType(InputStream in) throws IOException {
        byte[] bytes = new byte[7];
        bytes[0] = (byte)in.read();
        bytes[1] = (byte)in.read();
        if (bytes[1] == 10) {
            switch (bytes[0]) {
                case 65: 
                case 66: 
                case 88: {
                    return bytes[0];
                }
            }
            return -1;
        }
        for (int i = 2; i != 7; ++i) {
            bytes[i] = (byte)in.read();
        }
        String header = new String(bytes, 0, 5);
        if (header.equals("RDA2\n")) {
            return 65;
        }
        if (header.equals("RDB2\n")) {
            return 66;
        }
        if (header.equals("RDX2\n")) {
            return 88;
        }
        return -1;
    }

    private static StreamReader createStreamReader(byte type, InputStream conn) throws IOException {
        switch (type) {
            case 66: 
            case 88: {
                return new XdrReader(conn);
            }
            case 65: {
                return new AsciiReader(conn);
            }
        }
        throw new IOException("Unknown format");
    }

    public SEXP readExp() throws IOException {
        int flags = this.in.readInt();
        switch (Flags.getType(flags)) {
            case 254: {
                return Null.INSTANCE;
            }
            case 242: {
                return Environment.EMPTY;
            }
            case 241: {
                return this.readContext.getBaseEnvironment();
            }
            case 253: {
                return this.readContext.getGlobalEnvironment();
            }
            case 252: {
                return Symbol.UNBOUND_VALUE;
            }
            case 251: {
                return Symbol.MISSING_ARG;
            }
            case 250: {
                return this.readContext.getBaseNamespaceEnvironment();
            }
            case 255: {
                return this.readReference(flags);
            }
            case 247: {
                return this.readPersistentExp();
            }
            case 1: {
                return this.readSymbol();
            }
            case 248: {
                return this.readPackage();
            }
            case 249: {
                return this.readNamespace();
            }
            case 4: {
                return this.readEnv(flags);
            }
            case 2: {
                return this.readPairList(flags);
            }
            case 6: {
                return this.readLangExp(flags);
            }
            case 3: {
                return this.readClosure(flags);
            }
            case 5: {
                return this.readPromise(flags);
            }
            case 17: {
                return this.readDotExp(flags);
            }
            case 22: {
                return this.readExternalPointer(flags);
            }
            case 23: {
                return this.readWeakReference(flags);
            }
            case 7: 
            case 8: {
                return this.readPrimitive(flags);
            }
            case 9: {
                return this.readCharExp(flags);
            }
            case 10: {
                return this.readLogical(flags);
            }
            case 13: {
                return this.readIntVector(flags);
            }
            case 14: {
                return this.readDoubleExp(flags);
            }
            case 15: {
                return this.readComplexExp(flags);
            }
            case 16: {
                return this.readStringVector(flags);
            }
            case 19: {
                return this.readListExp(flags);
            }
            case 20: {
                return this.readExpExp(flags);
            }
            case 21: {
                return this.readBytecode(flags);
            }
            case 246: {
                throw new IOException("this version of R cannot read class references");
            }
            case 245: {
                throw new IOException("this version of R cannot read generic function references");
            }
            case 24: {
                return this.rawRawVector(flags);
            }
            case 25: {
                return this.readS4XP(flags);
            }
        }
        throw new IOException(String.format("ReadItem: unknown type %d, perhaps written by later version of R", Flags.getType(flags)));
    }

    private SEXP rawRawVector(int flags) throws IOException {
        int length2 = this.in.readInt();
        byte[] bytes = this.in.readString(length2);
        AttributeMap attributes2 = this.readAttributes(flags);
        return new RawVector(bytes, attributes2);
    }

    private SEXP readPromise(int flags) throws IOException {
        AttributeMap attributes2 = this.readAttributes(flags);
        SEXP env2 = this.readTag(flags);
        SEXP value = this.readExp();
        SEXP expr = this.readExp();
        if (env2 != Null.INSTANCE) {
            return this.readContext.createPromise(expr, (Environment)env2);
        }
        return new Promise(expr, value);
    }

    private SEXP readClosure(int flags) throws IOException {
        AttributeMap attributes2 = this.readAttributes(flags);
        Environment env2 = (Environment)this.readTag(flags);
        PairList formals2 = (PairList)this.readExp();
        SEXP body2 = this.readExp();
        return new Closure(env2, formals2, body2, attributes2);
    }

    private SEXP readLangExp(int flags) throws IOException {
        AttributeMap attributes2 = this.readAttributes(flags);
        SEXP tag = this.readTag(flags);
        SEXP function2 = this.readExp();
        PairList arguments = (PairList)this.readExp();
        return new FunctionCall(function2, arguments, attributes2);
    }

    private SEXP readBytecode(int flags) throws IOException {
        int nReps = this.in.readInt();
        SEXP[] reps = new SEXP[nReps];
        return this.readBC1(reps);
    }

    private SEXP readBC1(SEXP[] reps) throws IOException {
        SEXP code = this.readExp();
        SEXP[] constants = this.readBytecodeConstants(reps);
        return constants[0];
    }

    private SEXP[] readBytecodeConstants(SEXP[] reps) throws IOException {
        int nEntries = this.in.readInt();
        SEXP[] pool = new SEXP[nEntries];
        block4: for (int i = 0; i < nEntries; ++i) {
            int type = this.in.readInt();
            switch (type) {
                case 21: {
                    pool[i] = this.readBC1(reps);
                    continue block4;
                }
                case 2: 
                case 6: 
                case 239: 
                case 240: 
                case 243: 
                case 244: {
                    pool[i] = this.readBCLang(type, reps);
                    continue block4;
                }
                default: {
                    pool[i] = this.readExp();
                }
            }
        }
        return pool;
    }

    private SEXP readBCLang(int type, SEXP[] reps) throws IOException {
        switch (type) {
            case 243: {
                return reps[this.in.readInt()];
            }
            case 2: 
            case 6: 
            case 239: 
            case 240: 
            case 244: {
                PairList.Node ans;
                AttributeMap attributes2;
                int pos = -1;
                if (type == 244) {
                    pos = this.in.readInt();
                    type = this.in.readInt();
                }
                switch (type) {
                    case 239: 
                    case 240: {
                        attributes2 = this.readAttributes();
                        break;
                    }
                    default: {
                        attributes2 = AttributeMap.EMPTY;
                    }
                }
                switch (type) {
                    case 6: 
                    case 240: {
                        ans = new FunctionCall((SEXP)Null.INSTANCE, Null.INSTANCE, attributes2);
                        break;
                    }
                    case 2: 
                    case 239: {
                        ans = new PairList.Node(Null.INSTANCE, Null.INSTANCE, attributes2, Null.INSTANCE);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("BCLang type: " + type);
                    }
                }
                if (pos >= 0) {
                    reps[pos] = ans;
                }
                ans.setTag(this.readExp());
                ans.setValue(this.readBCLang(this.in.readInt(), reps));
                SEXP next = this.readBCLang(this.in.readInt(), reps);
                if (next != Null.INSTANCE) {
                    ans.setNextNode((PairList.Node)next);
                }
                return ans;
            }
        }
        return this.readExp();
    }

    private SEXP readDotExp(int flags) throws IOException {
        return PromisePairList.Builder.fromPairList(this.readPairList(flags));
    }

    private PairList readPairList(int flags) throws IOException {
        PairList.Node head = null;
        PairList.Node tail = null;
        while (Flags.getType(flags) != 254) {
            AttributeMap attributes2 = this.readAttributes(flags);
            SEXP tag = this.readTag(flags);
            SEXP value = this.readExp();
            if (tag == Symbols.ROW_NAMES && RowNamesVector.isOldCompactForm(value)) {
                value = RowNamesVector.fromOldCompactForm(value);
            }
            PairList.Node node = new PairList.Node(tag, value, attributes2, Null.INSTANCE);
            if (head == null) {
                head = node;
                tail = node;
            } else {
                tail.setNextNode(node);
                tail = node;
            }
            flags = this.in.readInt();
        }
        return (PairList)((Object)(head == null ? Null.INSTANCE : head));
    }

    private SEXP readTag(int flags) throws IOException {
        return Flags.hasTag(flags) ? this.readExp() : Null.INSTANCE;
    }

    private AttributeMap readAttributes(int flags) throws IOException {
        if (Flags.hasAttributes(flags)) {
            return this.readAttributes();
        }
        return AttributeMap.EMPTY;
    }

    private AttributeMap readAttributes() throws IOException {
        IntVector rniv;
        SEXP pairList = this.readExp();
        AttributeMap attributes2 = AttributeMap.fromPairList((PairList)pairList);
        SEXP rns = attributes2.get(Symbols.ROW_NAMES);
        if (rns instanceof IntVector && (rniv = (IntVector)rns).length() == 2 && rniv.isElementNA(0)) {
            ConvertingStringVector csv = new ConvertingStringVector(IntSequence.fromTo(1, rniv.getElementAsInt(1)), AttributeMap.EMPTY);
            AttributeMap.Builder amb = attributes2.copy();
            amb.set(Symbols.ROW_NAMES, (SEXP)csv);
            attributes2 = amb.build();
        }
        return attributes2;
    }

    private SEXP readPackage() throws IOException {
        throw new IOException("package");
    }

    private SEXP readReference(int flags) throws IOException {
        int i = this.readReferenceIndex(flags);
        return this.referenceTable.get(i);
    }

    private int readReferenceIndex(int flags) throws IOException {
        int i = Flags.unpackRefIndex(flags);
        if (i == 0) {
            return this.in.readInt() - 1;
        }
        return i - 1;
    }

    private SEXP readSymbol() throws IOException {
        int flags = this.in.readInt();
        if (Flags.getType(flags) != 9) {
            throw new IllegalStateException("Expected a CHARSXP");
        }
        int length2 = this.in.readInt();
        String name = length2 < 0 ? "NA" : new String(this.in.readString(length2));
        return this.addReadRef(Symbol.get(name));
    }

    private SEXP addReadRef(SEXP value) {
        this.referenceTable.add(value);
        return value;
    }

    private SEXP readNamespace() throws IOException {
        StringVector name = this.readPersistentNamesVector();
        Environment namespace = this.readContext.findNamespace(Symbol.get(name.getElementAsString(0)));
        if (namespace == Null.INSTANCE) {
            throw new IllegalStateException("Cannot find namespace '" + name + "'");
        }
        return this.addReadRef(namespace);
    }

    private SEXP readEnv(int flags) throws IOException {
        Environment env2 = Environment.createChildEnvironment(Environment.EMPTY);
        this.addReadRef(env2);
        boolean locked = this.in.readInt() == 1;
        SEXP parent2 = this.readExp();
        SEXP frame2 = this.readExp();
        SEXP hashtab = this.readExp();
        for (int i = 0; i < hashtab.length(); ++i) {
            PairList node = (PairList)hashtab.getElementAsSEXP(i);
            while (node != Null.INSTANCE) {
                env2.setVariable(node.getTag(), ((PairList.Node)node).getValue());
                node = ((PairList.Node)node).getNext();
            }
        }
        SEXP attributes2 = this.readExp();
        env2.setParent(parent2 == Null.INSTANCE ? Environment.EMPTY : (Environment)parent2);
        env2.setVariables((PairList)frame2);
        if (locked) {
            env2.lock(true);
        }
        return env2;
    }

    private SEXP readS4XP(int flags) throws IOException {
        return new S4Object(this.readAttributes(flags));
    }

    private SEXP readListExp(int flags) throws IOException {
        SEXP[] values = this.readExpArray();
        AttributeMap attributes2 = this.readAttributes(flags);
        return new ListVector(values, attributes2);
    }

    private SEXP readExpExp(int flags) throws IOException {
        SEXP[] values = this.readExpArray();
        AttributeMap attributes2 = this.readAttributes(flags);
        return new ExpressionVector(values, attributes2);
    }

    private SEXP[] readExpArray() throws IOException {
        int length2 = this.in.readInt();
        SEXP[] values = new SEXP[length2];
        for (int i = 0; i != length2; ++i) {
            values[i] = this.readExp();
        }
        return values;
    }

    private SEXP readStringVector(int flags) throws IOException {
        int length2 = this.in.readInt();
        String[] values = new String[length2];
        for (int i = 0; i != length2; ++i) {
            values[i] = ((CHARSEXP)this.readExp()).getValue();
        }
        return new StringArrayVector(values, this.readAttributes(flags));
    }

    private SEXP readComplexExp(int flags) throws IOException {
        int length2 = this.in.readInt();
        Complex[] values = new Complex[length2];
        for (int i = 0; i != length2; ++i) {
            values[i] = new Complex(this.in.readDouble(), this.in.readDouble());
        }
        return new ComplexArrayVector(values, this.readAttributes(flags));
    }

    private SEXP readDoubleExp(int flags) throws IOException {
        int length2 = this.in.readInt();
        double[] values = new double[length2];
        for (int i = 0; i != length2; ++i) {
            values[i] = this.in.readDouble();
        }
        return new DoubleArrayVector(values, this.readAttributes(flags));
    }

    private SEXP readIntVector(int flags) throws IOException {
        int length2 = this.in.readInt();
        IntBuffer buffer = this.in.readIntBuffer(length2);
        return new IntBufferVector(buffer, length2, this.readAttributes(flags));
    }

    private SEXP readLogical(int flags) throws IOException {
        int length2 = this.in.readInt();
        int[] values = new int[length2];
        for (int i = 0; i != length2; ++i) {
            values[i] = this.in.readInt();
        }
        return new LogicalArrayVector(values, this.readAttributes(flags));
    }

    private SEXP readCharExp(int flags) throws IOException {
        int length2 = this.in.readInt();
        if (length2 == -1) {
            return new CHARSEXP(StringVector.NA);
        }
        byte[] buf = this.in.readString(length2);
        if (Flags.isUTF8Encoded(flags)) {
            return new CHARSEXP(new String(buf, "UTF8"));
        }
        if (Flags.isLatin1Encoded(flags)) {
            return new CHARSEXP(new String(buf, "Latin1"));
        }
        return new CHARSEXP(new String(buf));
    }

    private SEXP readPrimitive(int flags) throws IOException {
        int nameLength = this.in.readInt();
        String name = new String(this.in.readString(nameLength));
        return Primitives.getBuiltin(name);
    }

    private SEXP readWeakReference(int flags) throws IOException {
        throw new IOException("weakRef not yet impl");
    }

    private SEXP readExternalPointer(int flags) throws IOException {
        ExternalPtr ptr = new ExternalPtr(null);
        this.addReadRef(ptr);
        this.readExp();
        this.readExp();
        ptr = (ExternalPtr)ptr.setAttributes(this.readAttributes(flags));
        return ptr;
    }

    private SEXP readPersistentExp() throws IOException {
        if (this.restorer == null) {
            throw new IOException("no restore method available");
        }
        return this.addReadRef(this.restorer.restore(this.readPersistentNamesVector()));
    }

    private StringVector readPersistentNamesVector() throws IOException {
        if (this.in.readInt() != 0) {
            throw new IOException("names in persistent strings are not supported yet");
        }
        int len = this.in.readInt();
        String[] values = new String[len];
        for (int i = 0; i != len; ++i) {
            values[i] = ((CHARSEXP)this.readExp()).getValue();
        }
        return new StringArrayVector(values);
    }

    @Override
    public void close() throws IOException {
        this.conn.close();
    }

    public static interface PersistentRestorer {
        public SEXP restore(StringVector var1);
    }

    private static class XdrReader
    implements StreamReader {
        private final DataInputStream in;

        private XdrReader(DataInputStream in) throws IOException {
            this.in = in;
        }

        public XdrReader(InputStream conn) throws IOException {
            this(new DataInputStream(new BufferedInputStream(conn)));
        }

        @Override
        public int readInt() throws IOException {
            return this.in.readInt();
        }

        @Override
        public IntBuffer readIntBuffer(int size) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size * 4);
            ReadableByteChannel channel = Channels.newChannel(this.in);
            while (byteBuffer.hasRemaining()) {
                channel.read(byteBuffer);
            }
            byteBuffer = (ByteBuffer)byteBuffer.rewind();
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            assert (intBuffer.limit() == size);
            return intBuffer;
        }

        @Override
        public byte[] readString(int length2) throws IOException {
            byte[] buf = new byte[length2];
            this.in.readFully(buf);
            return buf;
        }

        @Override
        public double readDouble() throws IOException {
            long bits = this.in.readLong();
            return Double.longBitsToDouble(bits);
        }
    }

    private static class AsciiReader
    implements StreamReader {
        private BufferedReader reader;

        private AsciiReader(BufferedReader reader) {
            this.reader = reader;
        }

        private AsciiReader(InputStream in) {
            this(new BufferedReader(new InputStreamReader(in)));
        }

        public String readWord() throws IOException {
            int codePoint;
            do {
                if ((codePoint = this.reader.read()) != -1) continue;
                throw new EOFException();
            } while (Character.isWhitespace(codePoint));
            StringBuilder sb = new StringBuilder();
            while (!Character.isWhitespace(codePoint)) {
                sb.appendCodePoint(codePoint);
                codePoint = this.reader.read();
            }
            return sb.toString();
        }

        @Override
        public int readInt() throws IOException {
            String word = this.readWord();
            if ("NA".equals(word)) {
                return Integer.MIN_VALUE;
            }
            return Integer.parseInt(word);
        }

        @Override
        public IntBuffer readIntBuffer(int size) throws IOException {
            int[] array2 = new int[size];
            for (int i = 0; i != size; ++i) {
                array2[i] = this.readInt();
            }
            return IntBuffer.wrap(array2);
        }

        @Override
        public double readDouble() throws IOException {
            String word = this.readWord();
            if ("NA".equals(word)) {
                return DoubleVector.NA;
            }
            if ("Inf".equals(word)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-Inf".equals(word)) {
                return Double.NEGATIVE_INFINITY;
            }
            return NumericLiterals.parseDouble(word);
        }

        @Override
        public byte[] readString(int length2) throws IOException {
            byte[] buf = null;
            if (length2 > 0) {
                int codePoint;
                buf = new byte[length2];
                do {
                    if ((codePoint = this.reader.read()) != -1) continue;
                    throw new EOFException();
                } while (Character.isWhitespace(codePoint));
                block15: for (int i = 0; i < length2; ++i) {
                    if (codePoint == 92) {
                        codePoint = this.reader.read();
                        switch (codePoint) {
                            case 110: {
                                buf[i] = 10;
                                break;
                            }
                            case 116: {
                                buf[i] = 9;
                                break;
                            }
                            case 118: {
                                buf[i] = 11;
                                break;
                            }
                            case 98: {
                                buf[i] = 8;
                                break;
                            }
                            case 114: {
                                buf[i] = 13;
                                break;
                            }
                            case 102: {
                                buf[i] = 12;
                                break;
                            }
                            case 97: {
                                buf[i] = 7;
                                break;
                            }
                            case 92: {
                                buf[i] = 92;
                                break;
                            }
                            case 63: {
                                buf[i] = 127;
                                break;
                            }
                            case 39: {
                                buf[i] = 39;
                                break;
                            }
                            case 34: {
                                buf[i] = 34;
                                break;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: {
                                int d = 0;
                                for (int j = 0; 48 <= codePoint && codePoint < 56 && j < 3; ++j) {
                                    d = d * 8 + (codePoint - 48);
                                    codePoint = this.reader.read();
                                }
                                buf[i] = (byte)d;
                                continue block15;
                            }
                            default: {
                                buf[i] = (byte)codePoint;
                                break;
                            }
                        }
                    } else {
                        buf[i] = (byte)codePoint;
                    }
                    if ((codePoint = this.reader.read()) != -1) continue;
                    throw new EOFException();
                }
            }
            return buf;
        }
    }

    private static interface StreamReader {
        public int readInt() throws IOException;

        public IntBuffer readIntBuffer(int var1) throws IOException;

        public byte[] readString(int var1) throws IOException;

        public double readDouble() throws IOException;
    }
}

