/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.collect;

import java.util.AbstractList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.Nullable;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.ImmutableList;
import org.renjin.repackaged.guava.math.IntMath;

@GwtCompatible
final class CartesianList<E>
extends AbstractList<List<E>>
implements RandomAccess {
    private final transient ImmutableList<List<E>> axes;
    private final transient int[] axesSizeProduct;

    static <E> List<List<E>> create(List<? extends List<? extends E>> lists) {
        ImmutableList.Builder axesBuilder = new ImmutableList.Builder(lists.size());
        for (List<E> list2 : lists) {
            ImmutableList<E> copy2 = ImmutableList.copyOf(list2);
            if (copy2.isEmpty()) {
                return ImmutableList.of();
            }
            axesBuilder.add(copy2);
        }
        return new CartesianList<E>(axesBuilder.build());
    }

    CartesianList(ImmutableList<List<E>> axes) {
        this.axes = axes;
        int[] axesSizeProduct = new int[axes.size() + 1];
        axesSizeProduct[axes.size()] = 1;
        try {
            for (int i = axes.size() - 1; i >= 0; --i) {
                axesSizeProduct[i] = IntMath.checkedMultiply(axesSizeProduct[i + 1], ((List)axes.get(i)).size());
            }
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Cartesian product too large; must have size at most Integer.MAX_VALUE");
        }
        this.axesSizeProduct = axesSizeProduct;
    }

    private int getAxisIndexForProductIndex(int index, int axis2) {
        return index / this.axesSizeProduct[axis2 + 1] % ((List)this.axes.get(axis2)).size();
    }

    @Override
    public ImmutableList<E> get(final int index) {
        Preconditions.checkElementIndex(index, this.size());
        return new ImmutableList<E>(){

            @Override
            public int size() {
                return CartesianList.this.axes.size();
            }

            @Override
            public E get(int axis2) {
                Preconditions.checkElementIndex(axis2, this.size());
                int axisIndex = CartesianList.this.getAxisIndexForProductIndex(index, axis2);
                return ((List)CartesianList.this.axes.get(axis2)).get(axisIndex);
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        };
    }

    @Override
    public int size() {
        return this.axesSizeProduct[0];
    }

    @Override
    public boolean contains(@Nullable Object o) {
        if (!(o instanceof List)) {
            return false;
        }
        List list2 = (List)o;
        if (list2.size() != this.axes.size()) {
            return false;
        }
        ListIterator itr = list2.listIterator();
        while (itr.hasNext()) {
            int index = itr.nextIndex();
            if (((List)this.axes.get(index)).contains(itr.next())) continue;
            return false;
        }
        return true;
    }
}

