/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;

public class LongArrayVector
extends DoubleVector {
    private long[] values;

    public LongArrayVector(long value) {
        this.values = new long[]{value};
    }

    private LongArrayVector(long[] values, AttributeMap attributes2) {
        super(attributes2);
        this.values = values;
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public int getElementAsInt(int i) {
        long value = this.values[i];
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    @Override
    public double getElementAsDouble(int index) {
        return this.values[index];
    }

    @Override
    public String getElementAsString(int index) {
        return Long.toString(this.values[index]);
    }

    public long getElementAsLong(int index) {
        return this.values[index];
    }

    @Override
    public boolean isElementNA(int index) {
        return false;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new LongArrayVector(this.values, attributes2);
    }
}

