/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import org.apache.commons.math.linear.AbstractRealMatrix;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.RealMatrix;
import org.renjin.primitives.Indexes;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.Vector;

public class CommonsMath {
    private CommonsMath() {
    }

    public static RealMatrix asRealMatrix(Vector vector2) {
        return new MatrixAdapter(vector2);
    }

    public static RealMatrix asRealMatrix(Vector vector2, int numRows, int numCols) {
        if (numRows * numCols != vector2.length()) {
            throw new IllegalArgumentException("numRows * numCols must equal the length of the vector");
        }
        return new MatrixAdapter(vector2, numRows, numCols);
    }

    public static Vector asDoubleVector(RealMatrix matrix2) {
        int nrows = matrix2.getRowDimension();
        int ncols = matrix2.getColumnDimension();
        DoubleArrayVector.Builder vector2 = DoubleArrayVector.Builder.withInitialSize(nrows * ncols);
        vector2.setDim(nrows, ncols);
        int vector_i = 0;
        for (int i = 0; i != ncols; ++i) {
            for (int j = 0; j != nrows; ++j) {
                vector2.set(vector_i++, matrix2.getEntry(j, i));
            }
        }
        return vector2.build();
    }

    private static class MatrixAdapter
    extends AbstractRealMatrix {
        private int nrows;
        private int ncols;
        private Vector vector;

        public MatrixAdapter(Vector vector2) {
            this.vector = vector2;
            Vector dim2 = vector2.getAttributes().getDim();
            if (dim2 == Null.INSTANCE) {
                throw new IllegalArgumentException("the vector has no 'dim' attribute");
            }
            if (dim2.length() != 2) {
                throw new IllegalArgumentException("the vector has is not a matrix; it has " + dim2.length() + " dimension(s).");
            }
            this.nrows = dim2.getElementAsInt(0);
            this.ncols = dim2.getElementAsInt(1);
        }

        public MatrixAdapter(Vector vector2, int nrows, int ncols) {
            this.vector = vector2;
            this.nrows = nrows;
            this.ncols = ncols;
        }

        @Override
        public RealMatrix createMatrix(int rowDimension, int columnDimension) {
            return new BlockRealMatrix(rowDimension, columnDimension);
        }

        @Override
        public RealMatrix copy() {
            return new MatrixAdapter(this.vector.newCopyBuilder().build());
        }

        @Override
        public double getEntry(int row2, int column) throws MatrixIndexException {
            return this.vector.getElementAsDouble(Indexes.matrixIndexToVectorIndex(row2, column, this.nrows, this.ncols));
        }

        @Override
        public void setEntry(int row2, int column, double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addToEntry(int row2, int column, double increment) throws MatrixIndexException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void multiplyEntry(int row2, int column, double factor) throws MatrixIndexException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRowDimension() {
            return this.nrows;
        }

        @Override
        public int getColumnDimension() {
            return this.ncols;
        }
    }
}

