/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.cache.AbstractFilesCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFilesCache
extends AbstractFilesCache {
    private final ConcurrentMap<FileSystem, ConcurrentMap<FileName, FileObject>> filesystemCache = new ConcurrentHashMap<FileSystem, ConcurrentMap<FileName, FileObject>>(10);

    @Override
    public void putFile(FileObject file2) {
        ConcurrentMap<FileName, FileObject> files2 = this.getOrCreateFilesystemCache(file2.getFileSystem());
        files2.put(file2.getName(), file2);
    }

    @Override
    public boolean putFileIfAbsent(FileObject file2) {
        ConcurrentMap<FileName, FileObject> files2 = this.getOrCreateFilesystemCache(file2.getFileSystem());
        return files2.putIfAbsent(file2.getName(), file2) == null;
    }

    @Override
    public FileObject getFile(FileSystem filesystem, FileName name) {
        ConcurrentMap<FileName, FileObject> files2 = this.getOrCreateFilesystemCache(filesystem);
        return (FileObject)files2.get(name);
    }

    @Override
    public void clear(FileSystem filesystem) {
        ConcurrentMap<FileName, FileObject> files2 = this.getOrCreateFilesystemCache(filesystem);
        files2.clear();
    }

    protected ConcurrentMap<FileName, FileObject> getOrCreateFilesystemCache(FileSystem filesystem) {
        ConcurrentMap files2 = (ConcurrentMap)this.filesystemCache.get(filesystem);
        if (files2 == null) {
            this.filesystemCache.putIfAbsent(filesystem, new ConcurrentHashMap());
            files2 = (ConcurrentMap)this.filesystemCache.get(filesystem);
        }
        return files2;
    }

    @Override
    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    @Override
    public void removeFile(FileSystem filesystem, FileName name) {
        ConcurrentMap<FileName, FileObject> files2 = this.getOrCreateFilesystemCache(filesystem);
        files2.remove(name);
    }

    public void touchFile(FileObject file2) {
    }
}

