/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.SsaEdge;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.guava.collect.HashMultimap;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Multimap;

public class UseDefMap {
    private Map<LValue, Assignment> assignmentMap = Maps.newHashMap();
    private Map<LValue, BasicBlock> defBlockMap = Maps.newHashMap();
    private Multimap<LValue, BasicBlock> useBlockMap = HashMultimap.create();
    private Multimap<LValue, Statement> useStatementMap = HashMultimap.create();
    private final Set<LValue> variableUsages = new HashSet<LValue>();
    private final Multimap<LValue, SsaEdge> ssaEdges = HashMultimap.create();
    private ControlFlowGraph cfg;

    public UseDefMap(ControlFlowGraph cfg) {
        this.cfg = cfg;
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            for (Statement statement : basicBlock.getStatements()) {
                if (!(statement instanceof Assignment)) continue;
                Assignment assignment = (Assignment)statement;
                this.assignmentMap.put(assignment.getLHS(), assignment);
                this.defBlockMap.put(assignment.getLHS(), basicBlock);
            }
        }
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            for (Statement statement : basicBlock.getStatements()) {
                Expression rhs = statement.getRHS();
                if (rhs instanceof LValue) {
                    this.addSsaEdge((LValue)rhs, basicBlock, statement);
                    this.useBlockMap.put((LValue)rhs, basicBlock);
                    continue;
                }
                for (int i = 0; i != rhs.getChildCount(); ++i) {
                    Expression uses = rhs.childAt(i);
                    if (!(uses instanceof LValue)) continue;
                    this.addSsaEdge((LValue)uses, basicBlock, statement);
                    this.useBlockMap.put((LValue)uses, basicBlock);
                }
            }
        }
    }

    private void addSsaEdge(LValue variable, BasicBlock basicBlock, Statement usage) {
        Assignment definition = this.assignmentMap.get(variable);
        if (definition != null) {
            SsaEdge edge = new SsaEdge(definition, basicBlock, usage);
            this.ssaEdges.put(definition.getLHS(), edge);
            if (basicBlock != this.cfg.getExit()) {
                this.variableUsages.add(definition.getLHS());
            }
        }
    }

    public boolean isDefined(LValue variable) {
        return this.assignmentMap.containsKey(variable);
    }

    public Assignment getDefinition(LValue variable) {
        return this.assignmentMap.get(variable);
    }

    public BasicBlock getDefinitionBlock(LValue a) {
        return this.defBlockMap.get(a);
    }

    public Collection<SsaEdge> getSsaEdges(LValue lhs) {
        return this.ssaEdges.get(lhs);
    }

    public boolean isUsed(LValue variable) {
        return this.variableUsages.contains(variable);
    }

    public Set<LValue> getUsedVariables() {
        return this.variableUsages;
    }

    public Collection<BasicBlock> getUsedBlocks(LValue a) {
        return this.useBlockMap.get(a);
    }
}

