/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen.scalars;

import java.util.Map;
import org.apache.commons.math.complex.Complex;
import org.renjin.invoke.codegen.GeneratorDefinitionException;
import org.renjin.invoke.codegen.scalars.BooleanType;
import org.renjin.invoke.codegen.scalars.ByteType;
import org.renjin.invoke.codegen.scalars.ComplexType;
import org.renjin.invoke.codegen.scalars.DoubleType;
import org.renjin.invoke.codegen.scalars.FloatType;
import org.renjin.invoke.codegen.scalars.IntegerType;
import org.renjin.invoke.codegen.scalars.LogicalType;
import org.renjin.invoke.codegen.scalars.ScalarType;
import org.renjin.invoke.codegen.scalars.SexpType;
import org.renjin.invoke.codegen.scalars.StringType;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;

public class ScalarTypes {
    private static final ScalarTypes INSTANCE = new ScalarTypes();
    private Map<Class, ScalarType> types = Maps.newHashMap();
    private SexpType sexpType = new SexpType();

    private ScalarTypes() {
        this.types.put(Integer.TYPE, new IntegerType());
        this.types.put(String.class, new StringType());
        this.types.put(Boolean.TYPE, new BooleanType());
        this.types.put(Double.TYPE, new DoubleType());
        this.types.put(Float.TYPE, new FloatType());
        this.types.put(Logical.class, new LogicalType());
        this.types.put(Complex.class, new ComplexType());
        this.types.put(Byte.TYPE, new ByteType());
    }

    public static boolean has(Class clazz) {
        return ScalarTypes.INSTANCE.types.containsKey(clazz);
    }

    public static ScalarType get(Class clazz) {
        if (SEXP.class.isAssignableFrom(clazz)) {
            return ScalarTypes.INSTANCE.sexpType;
        }
        ScalarType type = ScalarTypes.INSTANCE.types.get(clazz);
        if (type == null) {
            throw new GeneratorDefinitionException(clazz.getName() + " cannot be recycled upon");
        }
        return type;
    }
}

