/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.dpois;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;

public class dnbinom {
    private dnbinom() {
    }

    public static double dnbinom_mu(double d, double d2, double d3, int n) {
        double d4;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d4 = d + d2 + d3;
        } else if (d3 < 0.0 || d2 < 0.0) {
            d4 = 0.0 / 0.0;
        } else {
            double d5 = Mathlib.round(d);
            double d6 = Math.abs(d - d5);
            double d7 = Math.abs(d);
            double d8 = fmax2.fmax2(1.0, d7) * 1.0E-7;
            if (d6 > d8) {
                Stdlib.printf(new BytePtr("non-integer x = %f\u0000".getBytes(), 0), d);
                double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
                d4 = iftmp$0;
            } else if (d < 0.0 || Builtins.__finite(d) == 0) {
                double iftmp$1 = n != 0 ? -1.0 / 0.0 : 0.0;
                d4 = iftmp$1;
            } else if (d == 0.0 && d2 == 0.0) {
                double iftmp$2 = n != 0 ? 0.0 : 1.0;
                d4 = iftmp$2;
            } else {
                d = Mathlib.round(d);
                if (Builtins.__finite(d2) == 0) {
                    d4 = dpois.dpois_raw(d, d3, n);
                } else if (d == 0.0) {
                    double iftmp$3;
                    if (n != 0) {
                        double iftmp$4;
                        if (d2 < d3) {
                            double d9 = d2 + d3;
                            iftmp$4 = Math.log(d2 / d9);
                        } else {
                            double d10 = -d3;
                            double d11 = d2 + d3;
                            iftmp$4 = Mathlib.log1p(d10 / d11);
                        }
                        iftmp$3 = iftmp$4 * d2;
                    } else {
                        double iftmp$5;
                        if (d2 < d3) {
                            double d12 = d2 + d3;
                            iftmp$5 = Math.log(d2 / d12);
                        } else {
                            double d13 = -d3;
                            double d14 = d2 + d3;
                            iftmp$5 = Mathlib.log1p(d13 / d14);
                        }
                        iftmp$3 = Math.exp(iftmp$5 * d2);
                    }
                    d4 = iftmp$3;
                } else if (d2 * 1.0E-10 > d) {
                    double iftmp$7;
                    double iftmp$6;
                    if (d2 < d3) {
                        double d15 = d2 / d3 + 1.0;
                        iftmp$6 = Math.log(d2 / d15);
                    } else {
                        double d16 = d3 / d2 + 1.0;
                        iftmp$6 = Math.log(d3 / d16);
                    }
                    double p = iftmp$6;
                    if (n != 0) {
                        double d17 = d * p - d3;
                        double d18 = lgamma.lgammafn(d + 1.0);
                        double d19 = d17 - d18;
                        double d20 = (d - 1.0) * d;
                        double d21 = d2 * 2.0;
                        double d22 = Mathlib.log1p(d20 / d21);
                        iftmp$7 = d19 + d22;
                    } else {
                        double d23 = d * p - d3;
                        double d24 = lgamma.lgammafn(d + 1.0);
                        double d25 = d23 - d24;
                        double d26 = (d - 1.0) * d;
                        double d27 = d2 * 2.0;
                        double d28 = Mathlib.log1p(d26 / d27);
                        iftmp$7 = Math.exp(d25 + d28);
                    }
                    d4 = iftmp$7;
                } else {
                    double d29 = d2 + d;
                    double p = d2 / d29;
                    double d30 = d2 + d3;
                    double d31 = d3 / d30;
                    double d32 = d2 + d3;
                    double d33 = d2 / d32;
                    double d34 = d + d2;
                    double ans = dbinom.dbinom_raw(d2, d34, d33, d31, n);
                    double iftmp$8 = n != 0 ? Math.log(p) + ans : p * ans;
                    d4 = iftmp$8;
                }
            }
        }
        return d4;
    }

    public static double dnbinom(double d, double d2, double d3, int n) {
        double d4;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d4 = d + d2 + d3;
        } else if (d3 <= 0.0 || d3 > 1.0 || d2 < 0.0) {
            d4 = 0.0 / 0.0;
        } else {
            double d5 = Mathlib.round(d);
            double d6 = Math.abs(d - d5);
            double d7 = Math.abs(d);
            double d8 = fmax2.fmax2(1.0, d7) * 1.0E-7;
            if (d6 > d8) {
                Stdlib.printf(new BytePtr("non-integer x = %f\u0000".getBytes(), 0), d);
                double iftmp$9 = n != 0 ? -1.0 / 0.0 : 0.0;
                d4 = iftmp$9;
            } else if (d < 0.0 || Builtins.__finite(d) == 0) {
                double iftmp$10 = n != 0 ? -1.0 / 0.0 : 0.0;
                d4 = iftmp$10;
            } else if (d == 0.0 && d2 == 0.0) {
                double iftmp$11 = n != 0 ? 0.0 : 1.0;
                d4 = iftmp$11;
            } else {
                d = Mathlib.round(d);
                if (Builtins.__finite(d2) == 0) {
                    d2 = Double.MAX_VALUE;
                }
                double d9 = 1.0 - d3;
                double d10 = d + d2;
                double ans = dbinom.dbinom_raw(d2, d10, d3, d9, n);
                double d11 = d2 + d;
                double p = d2 / d11;
                double iftmp$12 = n != 0 ? Math.log(p) + ans : p * ans;
                d4 = iftmp$12;
            }
        }
        return d4;
    }
}

