/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.primitives.matrix.StringMatrixBuilder;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class DebianControlFiles {
    @Internal
    public static SEXP readDCF(@Current Context context, SEXP conn, Vector requestedFields, boolean keepWhiteSpace) throws IOException {
        String line;
        HashMap<Cell, String> cells = Maps.newHashMap();
        ArrayList<String> fields = Lists.newArrayList();
        boolean allFields = true;
        if (requestedFields instanceof StringVector) {
            Iterables.addAll(fields, (StringVector)requestedFields);
            allFields = false;
        }
        int rowIndex = 0;
        boolean lastLineWasBlank = false;
        PushbackBufferedReader reader = Connections.getConnection(context, conn).getReader();
        Cell lastCell = null;
        while ((line = reader.readLine()) != null) {
            boolean lineIsBlank;
            boolean bl = lineIsBlank = line.trim().length() == 0;
            if (lineIsBlank) {
                if (!lastLineWasBlank) {
                    ++rowIndex;
                }
                lastCell = null;
            } else if (DebianControlFiles.isContinuation(line)) {
                if (lastCell == null) {
                    throw new EvalException("Malformed DCF exception '%s'", line);
                }
                StringBuilder value = new StringBuilder();
                value.append((String)cells.get(lastCell));
                value.append(" ");
                value.append(line.trim());
                cells.put(lastCell, value.toString());
            } else {
                String[] fieldValue = DebianControlFiles.parseLine(line);
                String fieldName = fieldValue[0];
                boolean includeValue = false;
                if (fields.contains(fieldName)) {
                    includeValue = true;
                } else if (allFields) {
                    fields.add(fieldName);
                    includeValue = true;
                }
                Cell cell = new Cell(rowIndex, fieldName);
                if (includeValue) {
                    cells.put(cell, fieldValue[1]);
                }
                lastCell = cell;
            }
            lastLineWasBlank = lineIsBlank;
        }
        int numRows = rowIndex;
        if (!lastLineWasBlank) {
            ++numRows;
        }
        return DebianControlFiles.constructMatrix(numRows, cells, fields);
    }

    protected static SEXP constructMatrix(int numRows, Map<Cell, String> cells, List<String> fields) {
        StringMatrixBuilder matrix2 = new StringMatrixBuilder(numRows, fields.size());
        for (int row2 = 0; row2 != numRows; ++row2) {
            for (int col2 = 0; col2 != fields.size(); ++col2) {
                String value = cells.get(new Cell(row2, fields.get(col2)));
                matrix2.setValue(row2, col2, value);
            }
        }
        matrix2.setColNames(fields);
        return matrix2.build();
    }

    private static boolean isContinuation(String line) {
        return Character.isWhitespace(line.charAt(0));
    }

    private static String[] parseLine(String line) {
        int colon2 = line.indexOf(58);
        if (colon2 == -1) {
            throw new EvalException("Malformed DCF line: '" + line + "'", new Object[0]);
        }
        String fieldName = line.substring(0, colon2).trim();
        String value = line.substring(colon2 + 1).trim();
        return new String[]{fieldName, value};
    }

    private static class Cell {
        private int row;
        private String field;

        public Cell(int row2, String column) {
            this.row = row2;
            this.field = column;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.row;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cell other = (Cell)obj;
            return this.row == other.row && this.field.equals(other.field);
        }
    }
}

