/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.provider.bzip2.BZip2Constants;
import org.apache.commons.vfs2.provider.bzip2.CRC;

class CBZip2InputStream
extends InputStream {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private CRC crc = new CRC();
    private boolean[] inUse = new boolean[256];
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][258];
    private int[][] base = new int[6][258];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private boolean streamEnd;
    private int currentChar = -1;
    private int currentState = 1;
    private int rNToGo;
    private int rTPos;
    private int tPos;
    private int i2;
    private int count;
    private int chPrev;
    private int ch2;
    private int j2;
    private char z;
    private boolean blockRandomised;
    private int blockSize100k;
    private int bsBuff;
    private int bsLive;
    private InputStream inputStream;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int last;
    private char[] mll8;
    private int nInUse;
    private int origPtr;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int[] tt;

    CBZip2InputStream(InputStream input) {
        this.bsSetStream(input);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    public int available() throws IOException {
        if (!this.streamEnd) {
            return 1;
        }
        return 0;
    }

    public int read() {
        if (this.streamEnd) {
            return -1;
        }
        int retChar = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return retChar;
    }

    private void setDecompressStructureSizes(int newSize100k) {
        if (0 > newSize100k || newSize100k > 9 || 0 > this.blockSize100k || this.blockSize100k > 9) {
            // empty if block
        }
        this.blockSize100k = newSize100k;
        if (newSize100k == 0) {
            return;
        }
        int n = 100000 * newSize100k;
        this.mll8 = new char[n];
        this.tt = new int[n];
    }

    private void setupBlock() {
        int i;
        int[] cftab = new int[257];
        cftab[0] = 0;
        for (i = 1; i <= 256; ++i) {
            cftab[i] = this.unzftab[i - 1];
        }
        for (i = 1; i <= 256; ++i) {
            int n = i;
            cftab[n] = cftab[n] + cftab[i - 1];
        }
        i = 0;
        while (i <= this.last) {
            char ch = this.mll8[i];
            this.tt[cftab[ch]] = i++;
            char c2 = ch;
            cftab[c2] = cftab[c2] + 1;
        }
        cftab = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.mll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.mll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.mll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = BZip2Constants.RAND_NUMS[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.mll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = BZip2Constants.RAND_NUMS[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                this.z = (char)(this.z ^ (this.rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void getAndMoveToFrontDecode() {
        int zj;
        int limitLast = 100000 * this.blockSize100k;
        this.origPtr = this.readVariableSizedInt(24);
        this.recvDecodingTables();
        int eob = this.nInUse + 1;
        int groupNo = -1;
        int groupPos = 0;
        for (int i = 0; i <= 255; ++i) {
            this.unzftab[i] = 0;
        }
        char[] yy = new char[256];
        for (int i = 0; i <= 255; ++i) {
            yy[i] = (char)i;
        }
        this.last = -1;
        groupPos = 49;
        char zt = this.selector[++groupNo];
        int zn = this.minLens[zt];
        int zvec = this.bsR(zn);
        while (zvec > this.limit[zt][zn]) {
            ++zn;
            while (this.bsLive < 1) {
                int zzi = 0;
                try {
                    zzi = this.inputStream.read();
                }
                catch (IOException e) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (zzi == -1) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                this.bsLive += 8;
            }
            zj = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            zvec = zvec << 1 | zj;
        }
        int nextSym = this.perm[zt][zvec - this.base[zt][zn]];
        while (nextSym != eob) {
            int j;
            if (nextSym == 0 || nextSym == 1) {
                char ch;
                int s = -1;
                int n = 1;
                do {
                    s = nextSym == 0 ? (s += 1 * n) : (s += 2 * n);
                    n *= 2;
                    if (groupPos == 0) {
                        ++groupNo;
                        groupPos = 50;
                    }
                    --groupPos;
                    zt = this.selector[groupNo];
                    zn = this.minLens[zt];
                    zvec = this.bsR(zn);
                    while (zvec > this.limit[zt][zn]) {
                        ++zn;
                        while (this.bsLive < 1) {
                            int zzi = 0;
                            try {
                                zzi = this.inputStream.read();
                            }
                            catch (IOException e) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (zzi == -1) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                            this.bsLive += 8;
                        }
                        zj = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        zvec = zvec << 1 | zj;
                    }
                } while ((nextSym = this.perm[zt][zvec - this.base[zt][zn]]) == 0 || nextSym == 1);
                char c2 = ch = this.seqToUnseq[yy[0]];
                this.unzftab[c2] = this.unzftab[c2] + ++s;
                while (s > 0) {
                    ++this.last;
                    this.mll8[this.last] = ch;
                    --s;
                }
                if (this.last < limitLast) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= limitLast) {
                CBZip2InputStream.blockOverrun();
            }
            char tmp = yy[nextSym - 1];
            char c3 = this.seqToUnseq[tmp];
            this.unzftab[c3] = this.unzftab[c3] + 1;
            this.mll8[this.last] = this.seqToUnseq[tmp];
            for (j = nextSym - 1; j > 3; j -= 4) {
                yy[j] = yy[j - 1];
                yy[j - 1] = yy[j - 2];
                yy[j - 2] = yy[j - 3];
                yy[j - 3] = yy[j - 4];
            }
            while (j > 0) {
                yy[j] = yy[j - 1];
                --j;
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                ++groupNo;
                groupPos = 50;
            }
            --groupPos;
            zt = this.selector[groupNo];
            zn = this.minLens[zt];
            zvec = this.bsR(zn);
            while (zvec > this.limit[zt][zn]) {
                ++zn;
                while (this.bsLive < 1) {
                    char ch = '\u0000';
                    try {
                        ch = (char)this.inputStream.read();
                    }
                    catch (IOException e) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    this.bsBuff = this.bsBuff << 8 | ch & 0xFF;
                    this.bsLive += 8;
                }
                zj = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                zvec = zvec << 1 | zj;
            }
            nextSym = this.perm[zt][zvec - this.base[zt][zn]];
        }
    }

    private void bsFinishedWithStream() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inputStream = null;
    }

    private int readVariableSizedInt(int numBits) {
        return this.bsR(numBits);
    }

    private char readUnsignedChar() {
        return (char)this.bsR(8);
    }

    private int readInt() {
        int u = 0;
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        return u;
    }

    private int bsR(int n) {
        while (this.bsLive < n) {
            int ch = 0;
            try {
                ch = this.inputStream.read();
            }
            catch (IOException ioe) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (ch == -1) {
                CBZip2InputStream.compressedStreamEOF();
            }
            this.bsBuff = this.bsBuff << 8 | ch & 0xFF;
            this.bsLive += 8;
        }
        int result = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return result;
    }

    private void bsSetStream(InputStream input) {
        this.inputStream = input;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private void complete() {
        this.storedCombinedCRC = this.readInt();
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.streamEnd = true;
    }

    private void endBlock() {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void hbCreateDecodeTables(int[] limit, int[] base, int[] perm, char[] length2, int minLen, int maxLen, int alphaSize) {
        int i;
        int i2;
        int pp = 0;
        for (i2 = minLen; i2 <= maxLen; ++i2) {
            for (int j = 0; j < alphaSize; ++j) {
                if (length2[j] != i2) continue;
                perm[pp] = j;
                ++pp;
            }
        }
        for (i2 = 0; i2 < 23; ++i2) {
            base[i2] = 0;
        }
        for (i2 = 0; i2 < alphaSize; ++i2) {
            int n = length2[i2] + '\u0001';
            base[n] = base[n] + 1;
        }
        for (i2 = 1; i2 < 23; ++i2) {
            int n = i2;
            base[n] = base[n] + base[i2 - 1];
        }
        for (i2 = 0; i2 < 23; ++i2) {
            limit[i2] = 0;
        }
        int vec = 0;
        for (i = minLen; i <= maxLen; ++i) {
            limit[i] = (vec += base[i + 1] - base[i]) - 1;
            vec <<= 1;
        }
        for (i = minLen + 1; i <= maxLen; ++i) {
            base[i] = (limit[i - 1] + 1 << 1) - base[i];
        }
    }

    private void initBlock() {
        char magic1 = this.readUnsignedChar();
        char magic2 = this.readUnsignedChar();
        char magic3 = this.readUnsignedChar();
        char magic4 = this.readUnsignedChar();
        char magic5 = this.readUnsignedChar();
        char magic6 = this.readUnsignedChar();
        if (magic1 == '\u0017' && magic2 == 'r' && magic3 == 'E' && magic4 == '8' && magic5 == 'P' && magic6 == '\u0090') {
            this.complete();
            return;
        }
        if (magic1 != '1' || magic2 != 'A' || magic3 != 'Y' || magic4 != '&' || magic5 != 'S' || magic6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.streamEnd = true;
            return;
        }
        this.storedBlockCRC = this.readInt();
        this.blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void initialize() {
        char magic3 = this.readUnsignedChar();
        char magic4 = this.readUnsignedChar();
        if (magic3 != 'h' || magic4 < '1' || magic4 > '9') {
            this.bsFinishedWithStream();
            this.streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(magic4 - 48);
        this.computedCombinedCRC = 0;
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    private void recvDecodingTables() {
        this.buildInUseTable();
        this.makeMaps();
        int alphaSize = this.nInUse + 2;
        int groupCount = this.bsR(3);
        int selectorCount = this.bsR(15);
        for (int i = 0; i < selectorCount; ++i) {
            int run = 0;
            while (this.bsR(1) == 1) {
                ++run;
            }
            this.selectorMtf[i] = (char)run;
        }
        char[] pos = new char[6];
        for (int v = 0; v < groupCount; v = (int)((char)(v + 1))) {
            pos[v] = v;
        }
        for (int i = 0; i < selectorCount; ++i) {
            int v;
            char tmp = pos[v];
            for (v = this.selectorMtf[i]; v > 0; --v) {
                pos[v] = pos[v - '\u0001'];
            }
            pos[0] = tmp;
            this.selector[i] = tmp;
        }
        char[][] len = new char[6][258];
        for (int i = 0; i < groupCount; ++i) {
            int curr = this.bsR(5);
            for (int j = 0; j < alphaSize; ++j) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++curr;
                        continue;
                    }
                    --curr;
                }
                len[i][j] = (char)curr;
            }
        }
        for (int k = 0; k < groupCount; ++k) {
            int minLen = 32;
            char maxLen = '\u0000';
            for (int i = 0; i < alphaSize; ++i) {
                if (len[k][i] > maxLen) {
                    maxLen = len[k][i];
                }
                if (len[k][i] >= minLen) continue;
                minLen = len[k][i];
            }
            this.hbCreateDecodeTables(this.limit[k], this.base[k], this.perm[k], len[k], minLen, maxLen, alphaSize);
            this.minLens[k] = minLen;
        }
    }

    private void buildInUseTable() {
        int i;
        boolean[] inUse16 = new boolean[16];
        for (i = 0; i < 16; ++i) {
            inUse16[i] = this.bsR(1) == 1;
        }
        for (i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            for (int j = 0; j < 16; ++j) {
                if (this.bsR(1) != 1) continue;
                this.inUse[i * 16 + j] = true;
            }
        }
    }

    public void close() throws IOException {
        this.bsFinishedWithStream();
    }
}

