/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import org.renjin.primitives.combine.view.PrefixedNameVector;
import org.renjin.primitives.sequence.RepStringVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class CombinedNames {
    public static final String EMPTY = "";

    private CombinedNames() {
    }

    public static StringVector combine(String prefix, Vector vector2) {
        boolean hasNames = vector2.getAttributes().hasNames();
        StringVector names2 = hasNames ? (StringVector)vector2.getNames() : RepStringVector.createConstantVector(EMPTY, vector2.length());
        if (!CombinedNames.isPresent(prefix)) {
            return names2;
        }
        boolean numberUnnamedElements = vector2 instanceof ListVector ? CombinedNames.countUnnamedElements((ListVector)vector2) > 1 : vector2.length() > 1;
        return new PrefixedNameVector(prefix, names2, numberUnnamedElements, AttributeMap.EMPTY);
    }

    public static String toString(String name) {
        if (StringVector.isNA(name)) {
            return "NA";
        }
        return name;
    }

    public static boolean isPresent(String name) {
        return name == null || name.length() > 0;
    }

    public static int countUnnamedElements(ListVector list2) {
        if (!list2.getAttributes().hasNames()) {
            return list2.length();
        }
        int count = 0;
        StringVector names2 = (StringVector)list2.getNames();
        for (int i = 0; i < names2.length(); ++i) {
            if (CombinedNames.isPresent(names2.getElementAsString(i))) continue;
            ++count;
        }
        return count;
    }

    public static boolean hasNames(String prefix, Vector value) {
        return CombinedNames.isPresent(prefix) || value.getAttributes().hasNames();
    }
}

