/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DotCall;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.serialization.RDataReader;
import org.renjin.primitives.io.serialization.RDataWriter;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.HasNamedValues;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class Serialization {
    private static final int DEFAULT_SERIALIZATION_VERSION = 0;

    @Internal
    public static SEXP unserializeFromConn(@Current Context context, SEXP conn, Environment rho) throws IOException {
        RDataReader reader = new RDataReader(context, Connections.getConnection(context, conn).getInputStream());
        return reader.readFile();
    }

    @Internal
    public static SEXP unserializeFromConn(@Current Context context, SEXP conn, Null nz) throws IOException {
        RDataReader reader = new RDataReader(context, Connections.getConnection(context, conn).getInputStream());
        return reader.readFile();
    }

    @Internal
    public static void serializeToConn(@Current Context context, SEXP object2, SEXP con, boolean ascii, SEXP versionSexp, SEXP refhook) throws IOException {
        if (ascii) {
            throw new EvalException("ascii format serialization not implemented", new Object[0]);
        }
        int version = 0;
        if (versionSexp instanceof Vector && versionSexp.length() == 1) {
            version = ((Vector)versionSexp).getElementAsInt(0);
        }
        RDataWriter writer = new RDataWriter(context, Serialization.createHook(context, refhook), Connections.getConnection(context, con).getOutputStream());
        writer.serialize(object2);
    }

    @Internal
    public static void saveToConn(@Current Context context, StringVector names2, SEXP connHandle, boolean ascii, SEXP version, Environment envir, boolean evalPromises) throws IOException {
        Connection con = Connections.getConnection(context, connHandle);
        boolean wasOpen = con.isOpen();
        if (!wasOpen) {
            con.open(new OpenSpec("wb"));
        }
        if (!con.canWrite()) {
            throw new EvalException("connection not open for writing", new Object[0]);
        }
        if (ascii) {
            throw new EvalException("ascii serialization not implemented", new Object[0]);
        }
        PairList.Builder list2 = new PairList.Builder();
        for (String name : names2) {
            SEXP value = envir.getVariable(name);
            if (value == Symbol.UNBOUND_VALUE) {
                throw new EvalException("object '%s' not found", name);
            }
            if (evalPromises) {
                value = value.force(context);
            }
            list2.add(name, value);
        }
        RDataWriter writer = new RDataWriter(context, con.getOutputStream());
        writer.save(list2.build());
        if (!wasOpen) {
            Connections.close(context, connHandle);
        }
    }

    @Internal
    public static void save(SEXP list2, SEXP file2, SEXP ascii, SEXP version, SEXP environment2, SEXP evalPromises) {
        throw new EvalException("Serialization version 1 not supported.", new Object[0]);
    }

    private static RDataWriter.PersistenceHook createHook(final Context context, final SEXP hookExp) {
        if (hookExp == Null.INSTANCE) {
            return null;
        }
        if (!(hookExp instanceof Closure)) {
            throw new EvalException("Illegal type for refhook", new Object[0]);
        }
        return new RDataWriter.PersistenceHook(){

            @Override
            public Vector apply(SEXP exp2) {
                Promise promisedExp = Promise.repromise(exp2);
                FunctionCall hookCall = FunctionCall.newCall(hookExp, promisedExp);
                SEXP result = context.evaluate(hookCall);
                if (result == Null.INSTANCE) {
                    return Null.INSTANCE;
                }
                if (result instanceof StringVector) {
                    return (StringVector)result;
                }
                throw new EvalException("Unexpected result from hook function: " + result, new Object[0]);
            }
        };
    }

    @Internal
    public static SEXP loadFromConn2(@Current Context context, SEXP conn, Environment env2) throws IOException {
        InputStream inputStream = Connections.getConnection(context, conn).getInputStream();
        return Serialization.load(context, env2, inputStream);
    }

    public static SEXP load(@Current Context context, Environment env2, InputStream inputStream) throws IOException {
        RDataReader reader = new RDataReader(context, inputStream);
        HasNamedValues data = (HasNamedValues)EvalException.checkedCast(reader.readFile());
        StringVector.Builder names2 = new StringVector.Builder();
        for (NamedValue pair : data.namedValues()) {
            env2.setVariable(Symbol.get(pair.getName()), pair.getValue());
            names2.add(pair.getName());
        }
        return names2.build();
    }

    @DotCall(value="R_serialize")
    public static SEXP serialize(@Current Context context, SEXP object2, SEXP connection2, boolean ascii, SEXP version, SEXP refhook) throws IOException {
        EvalException.check(refhook == Null.INSTANCE, "refHook != NULL has not been implemented yet.", new Object[0]);
        EvalException.check(connection2 == Null.INSTANCE, "Only connection = NULL has been implemented so far.", new Object[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDataWriter writer = new RDataWriter(context, baos, ascii ? SerializationType.ASCII : SerializationType.XDR);
        writer.serialize(object2);
        return new RawVector(baos.toByteArray());
    }

    @DotCall(value="R_unserialize")
    public static SEXP unserialize(@Current Context context, SEXP connection2, SEXP refhook) throws IOException {
        EvalException.check(refhook == Null.INSTANCE, "refHook != NULL has not been implemented yet.", new Object[0]);
        if (connection2 instanceof StringVector) {
            throw new EvalException("character vectors are no longer accepted by unserialize()", new Object[0]);
        }
        if (connection2 instanceof RawVector) {
            RDataReader reader = new RDataReader(context, new ByteArrayInputStream(((RawVector)connection2).toByteArray()));
            return reader.readFile();
        }
        return Serialization.unserializeFromConn(context, connection2, Null.INSTANCE);
    }

    public static enum SerializationType {
        ASCII,
        XDR,
        BINARY;

    }
}

