/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.vector.ConvertingDoubleVector;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public abstract class DoubleVector
extends AbstractAtomicVector
implements Iterable<Double> {
    public static final String TYPE_NAME = "double";
    public static final DoubleType VECTOR_TYPE = new DoubleType();
    public static final long NA_BITS = 9218868437227407266L;
    protected static final long LOWER_WORD_MASK = 0xFFFFFFFFL;
    public static final double NA = Double.longBitsToDouble(9218868437227407266L);
    public static final double NaN = Double.NaN;
    public static final double EPSILON = 2.220446E-16;
    public static final DoubleVector EMPTY = new DoubleArrayVector(new double[0]);
    public static final int NA_PAYLOAD = 1954;

    protected DoubleVector(AttributeMap attributes2) {
        super(attributes2);
    }

    protected DoubleVector() {
    }

    public static boolean isNaN(double x) {
        return Double.isNaN(x);
    }

    public static boolean isNA(double input) {
        if (Double.isNaN(input)) {
            long bits = Double.doubleToRawLongBits(input);
            long lowerWord = bits & 0xFFFFFFFFL;
            return lowerWord == 1954L;
        }
        return false;
    }

    public static boolean isFinite(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    @Override
    protected abstract SEXP cloneWithNewAttributes(AttributeMap var1);

    public double get(int i) {
        return this.getElementAsDouble(i);
    }

    @Override
    public Logical getElementAsLogical(int index) {
        double value = this.getElementAsDouble(index);
        if (DoubleVector.isNA(value)) {
            return Logical.NA;
        }
        if (value == 0.0) {
            return Logical.FALSE;
        }
        return Logical.TRUE;
    }

    @Override
    public int getElementAsRawLogical(int index) {
        double value = this.getElementAsDouble(index);
        if (DoubleVector.isNaN(value)) {
            return Integer.MIN_VALUE;
        }
        if (value == 0.0) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getElementAsString(int index) {
        double value = this.getElementAsDouble(index);
        if (DoubleVector.isNA(value)) {
            return StringVector.NA;
        }
        if (DoubleVector.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            if (value < 0.0) {
                return "-Inf";
            }
            return "Inf";
        }
        return NumericLiterals.toString(value);
    }

    @Override
    public int getElementAsInt(int index) {
        double value = this.getElementAsDouble(index);
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    @Override
    public Complex getElementAsComplex(int index) {
        double real2 = this.getElementAsDouble(index);
        if (DoubleVector.isNA(real2)) {
            return ComplexVector.NA;
        }
        return ComplexVector.complex(real2, 0.0);
    }

    @Override
    public abstract double getElementAsDouble(int var1);

    public DoubleVector getElementAsSEXP(int index) {
        return new DoubleArrayVector(this.getElementAsDouble(index));
    }

    @Override
    public Double getElementAsObject(int index) {
        return this.getElementAsDouble(index);
    }

    public static boolean match(double x, double y) {
        if (DoubleVector.isNA(x)) {
            return DoubleVector.isNA(y);
        }
        if (DoubleVector.isNaN(x)) {
            return DoubleVector.isNaN(y) && !DoubleVector.isNA(y);
        }
        return x == y;
    }

    @Override
    public int indexOf(AtomicVector vector2, int vectorIndex, int startIndex) {
        double value = vector2.getElementAsDouble(vectorIndex);
        for (int i = startIndex; i < this.length(); ++i) {
            if (!DoubleVector.match(value, this.getElementAsDouble(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int compare(int index1, int index2) {
        return Double.compare(this.getElementAsDouble(index1), this.getElementAsDouble(index2));
    }

    @Override
    public abstract int length();

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public Logical asLogical() {
        return this.getElementAsLogical(0);
    }

    @Override
    public String getImplicitClass() {
        return "numeric";
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterator<Double> iterator() {
        return new UnmodifiableIterator<Double>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index != DoubleVector.this.length();
            }

            @Override
            public Double next() {
                return DoubleVector.this.getElementAsDouble(this.index++);
            }
        };
    }

    protected static String toString(DoubleVector vector2) {
        if (vector2.length() == 1) {
            return Double.toString(vector2.getElementAsDouble(0));
        }
        StringBuilder sb = new StringBuilder("c(");
        for (int i = 0; i != Math.min(5, vector2.length()); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (DoubleVector.isNA(vector2.getElementAsDouble(i))) {
                sb.append("NA");
                continue;
            }
            sb.append(NumericLiterals.toString(vector2.getElementAsDouble(i)));
        }
        if (vector2.length() > 5) {
            sb.append(",... ").append(vector2.length()).append(" elements total");
        }
        return sb.append(")").toString();
    }

    @Override
    public double asReal() {
        if (this.length() == 0) {
            return NA;
        }
        return this.getElementAsDouble(0);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DoubleVector)) {
            return false;
        }
        DoubleVector vector2 = (DoubleVector)o;
        if (this.length() != vector2.length()) {
            return false;
        }
        for (int i = 0; i != this.length(); ++i) {
            double this_i = this.getElementAsDouble(i);
            double that_i = vector2.getElementAsDouble(i);
            if (DoubleVector.isNA(this_i) != DoubleVector.isNA(that_i)) {
                return false;
            }
            if (DoubleVector.isNaN(this_i) != DoubleVector.isNaN(that_i)) {
                return false;
            }
            if (DoubleVector.isNaN(this_i) || DoubleVector.isNaN(that_i) || this_i == that_i) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int hash = 37;
        for (int i = 0; i != this.length(); ++i) {
            long value = Double.doubleToRawLongBits(this.getElementAsDouble(i));
            hash += (int)(value ^ value >>> 32);
        }
        return hash;
    }

    @Override
    public DoubleArrayVector.Builder newCopyBuilder() {
        return new DoubleArrayVector.Builder(this);
    }

    @Override
    public DoubleArrayVector.Builder newBuilderWithInitialSize(int initialSize) {
        return new DoubleArrayVector.Builder(initialSize);
    }

    @Override
    public DoubleArrayVector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return new DoubleArrayVector.Builder(0, initialCapacity);
    }

    @Override
    public boolean isElementNA(int index) {
        return DoubleVector.isNA(this.getElementAsDouble(index));
    }

    @Override
    public boolean isElementNaN(int index) {
        return DoubleVector.isNaN(this.getElementAsDouble(index));
    }

    public static DoubleVector valueOf(double value) {
        return new DoubleArrayVector(value);
    }

    public static class DoubleType
    extends Vector.Type {
        public DoubleType() {
            super(4);
        }

        @Override
        public DoubleArrayVector.Builder newBuilder() {
            return new DoubleArrayVector.Builder(0, 0);
        }

        @Override
        public DoubleArrayVector.Builder newBuilderWithInitialSize(int length2) {
            return new DoubleArrayVector.Builder(length2);
        }

        @Override
        public DoubleArrayVector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return new DoubleArrayVector.Builder(0, initialCapacity);
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            return Double.compare(vector1.getElementAsDouble(index1), vector2.getElementAsDouble(index2));
        }

        @Override
        public boolean elementsEqual(Vector vector1, int index1, Vector vector2, int index2) {
            return vector1.getElementAsDouble(index1) == vector2.getElementAsDouble(index2);
        }

        @Override
        public DoubleVector to(Vector x) {
            if (x instanceof DoubleVector) {
                return (DoubleVector)x;
            }
            return new ConvertingDoubleVector(x, x.getAttributes());
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            return new DoubleArrayVector(vector2.getElementAsDouble(index));
        }
    }
}

