/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.WeightedEvaluation;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;

public class Variance
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = -9111962718267217978L;
    protected SecondMoment moment = null;
    protected boolean incMoment = true;
    private boolean isBiasCorrected = true;

    public Variance() {
        this.moment = new SecondMoment();
    }

    public Variance(SecondMoment m2) {
        this.incMoment = false;
        this.moment = m2;
    }

    public Variance(boolean isBiasCorrected) {
        this.moment = new SecondMoment();
        this.isBiasCorrected = isBiasCorrected;
    }

    public Variance(boolean isBiasCorrected, SecondMoment m2) {
        this.incMoment = false;
        this.moment = m2;
        this.isBiasCorrected = isBiasCorrected;
    }

    public Variance(Variance original) {
        Variance.copy(original, this);
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public double getResult() {
        if (this.moment.n == 0L) {
            return Double.NaN;
        }
        if (this.moment.n == 1L) {
            return 0.0;
        }
        if (this.isBiasCorrected) {
            return this.moment.m2 / ((double)this.moment.n - 1.0);
        }
        return this.moment.m2 / (double)this.moment.n;
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double evaluate(double[] values) {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        return this.evaluate(values, 0, values.length);
    }

    public double evaluate(double[] values, int begin, int length2) {
        double var = Double.NaN;
        if (this.test(values, begin, length2)) {
            this.clear();
            if (length2 == 1) {
                var = 0.0;
            } else if (length2 > 1) {
                Mean mean2 = new Mean();
                double m = mean2.evaluate(values, begin, length2);
                var = this.evaluate(values, m, begin, length2);
            }
        }
        return var;
    }

    public double evaluate(double[] values, double[] weights, int begin, int length2) {
        double var = Double.NaN;
        if (this.test(values, weights, begin, length2)) {
            this.clear();
            if (length2 == 1) {
                var = 0.0;
            } else if (length2 > 1) {
                Mean mean2 = new Mean();
                double m = mean2.evaluate(values, weights, begin, length2);
                var = this.evaluate(values, weights, m, begin, length2);
            }
        }
        return var;
    }

    public double evaluate(double[] values, double[] weights) {
        return this.evaluate(values, weights, 0, values.length);
    }

    public double evaluate(double[] values, double mean2, int begin, int length2) {
        double var = Double.NaN;
        if (this.test(values, begin, length2)) {
            if (length2 == 1) {
                var = 0.0;
            } else if (length2 > 1) {
                double accum = 0.0;
                double dev = 0.0;
                double accum2 = 0.0;
                for (int i = begin; i < begin + length2; ++i) {
                    dev = values[i] - mean2;
                    accum += dev * dev;
                    accum2 += dev;
                }
                double len = length2;
                var = this.isBiasCorrected ? (accum - accum2 * accum2 / len) / (len - 1.0) : (accum - accum2 * accum2 / len) / len;
            }
        }
        return var;
    }

    public double evaluate(double[] values, double mean2) {
        return this.evaluate(values, mean2, 0, values.length);
    }

    public double evaluate(double[] values, double[] weights, double mean2, int begin, int length2) {
        double var = Double.NaN;
        if (this.test(values, weights, begin, length2)) {
            if (length2 == 1) {
                var = 0.0;
            } else if (length2 > 1) {
                double accum = 0.0;
                double dev = 0.0;
                double accum2 = 0.0;
                for (int i = begin; i < begin + length2; ++i) {
                    dev = values[i] - mean2;
                    accum += weights[i] * (dev * dev);
                    accum2 += weights[i] * dev;
                }
                double sumWts = 0.0;
                for (int i = 0; i < weights.length; ++i) {
                    sumWts += weights[i];
                }
                var = this.isBiasCorrected ? (accum - accum2 * accum2 / sumWts) / (sumWts - 1.0) : (accum - accum2 * accum2 / sumWts) / sumWts;
            }
        }
        return var;
    }

    public double evaluate(double[] values, double[] weights, double mean2) {
        return this.evaluate(values, weights, mean2, 0, values.length);
    }

    public boolean isBiasCorrected() {
        return this.isBiasCorrected;
    }

    public void setBiasCorrected(boolean biasCorrected) {
        this.isBiasCorrected = biasCorrected;
    }

    public Variance copy() {
        Variance result = new Variance();
        Variance.copy(this, result);
        return result;
    }

    public static void copy(Variance source, Variance dest) {
        if (source == null || dest == null) {
            throw new NullArgumentException();
        }
        dest.setData(source.getDataRef());
        dest.moment = source.moment.copy();
        dest.isBiasCorrected = source.isBiasCorrected;
        dest.incMoment = source.incMoment;
    }
}

