/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.optimize.Optimizers;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Vector;

public class DeferredGraph {
    private DeferredNode rootNode;
    private List<DeferredNode> nodes = Lists.newArrayList();
    private int nextNodeId = 1;
    private IdentityHashMap<Vector, DeferredNode> nodeMap = Maps.newIdentityHashMap();

    public DeferredGraph(DeferredComputation root) {
        this.rootNode = new DeferredNode(this.nextNodeId(), root);
        this.nodes.add(this.rootNode);
        this.nodeMap.put(root, this.rootNode);
        this.addChildren(this.rootNode);
        Optimizers optimizers = new Optimizers();
        optimizers.optimize(this);
        this.removeOrphans();
    }

    private int nextNodeId() {
        return this.nextNodeId++;
    }

    private void addChildren(DeferredNode parent2) {
        for (Vector operand : parent2.getComputation().getOperands()) {
            DeferredNode node = this.nodeMap.get(operand);
            if (node == null) {
                node = new DeferredNode(this.nextNodeId(), operand);
                if (node.isComputation()) {
                    this.addChildren(node);
                }
                node = this.tryMerge(node);
                this.nodeMap.put(operand, node);
            }
            parent2.addOperand(node);
            node.addUse(parent2);
        }
    }

    private DeferredNode tryMerge(DeferredNode newNode) {
        for (DeferredNode node : this.nodeMap.values()) {
            if (!node.equivalent(newNode)) continue;
            return node;
        }
        this.nodes.add(newNode);
        return newNode;
    }

    public void dumpGraph() {
        try {
            File tempFile = File.createTempFile("deferred", ".dot");
            PrintWriter writer = new PrintWriter(tempFile);
            this.printGraph(writer);
            writer.close();
            System.out.println("Dumping compute graph to " + tempFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printGraph(PrintWriter writer) {
        writer.println("digraph G {");
        this.printEdges(writer);
        this.printNodes(writer);
        writer.println("}");
        writer.flush();
    }

    private void printEdges(PrintWriter writer) {
        for (DeferredNode node : this.nodes) {
            for (DeferredNode operand : node.getOperands()) {
                writer.println(node.getDebugId() + " -> " + operand.getDebugId());
            }
        }
    }

    private void printNodes(PrintWriter writer) {
        for (DeferredNode node : this.nodes) {
            String shape = "box";
            if (node.isComputation()) {
                shape = node.getComputation() instanceof MemoizedComputation ? "ellipse" : "parallelogram";
            }
            writer.println(node.getDebugId() + " [ label=\"" + node.getDebugLabel() + "\",  " + "shape=\"" + shape + "\"]");
        }
    }

    public DeferredNode getRoot() {
        return this.rootNode;
    }

    public List<DeferredNode> getNodes() {
        return this.nodes;
    }

    public void replaceNode(DeferredNode toReplace, DeferredNode replacementValue) {
        this.nodes.remove(toReplace);
        if (!this.nodes.contains(replacementValue)) {
            this.nodes.add(replacementValue);
        }
        for (DeferredNode operand : toReplace.getOperands()) {
            operand.removeUse(toReplace);
        }
        for (DeferredNode node : this.nodes) {
            node.replaceOperand(toReplace, replacementValue);
            node.replaceUse(toReplace, replacementValue);
        }
    }

    private void removeOrphans() {
        boolean removing;
        do {
            removing = false;
            ListIterator<DeferredNode> it = this.nodes.listIterator();
            while (it.hasNext()) {
                DeferredNode node = it.next();
                if (node == this.rootNode || node.isUsed()) continue;
                removing = true;
                it.remove();
            }
        } while (removing);
    }
}

