/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.renjin.gcc.annotations.Struct;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.CharTypes;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.timespec;
import org.renjin.gcc.runtime.tm;

public class Stdlib {
    public static final int CLOCKS_PER_SEC = 4;
    private static long PROGRAM_START = System.currentTimeMillis();
    public static BytePtr tzname;
    public static int timezone;
    public static int daylight;
    private static final int CLOCK_REALTIME = 0;
    private static final int CLOCK_MONOTONIC = 1;
    private static final int CLOCK_REALTIME_COARSE = 5;

    public static int strncmp(BytePtr x, BytePtr y, int n) {
        for (int i = 0; i < n; ++i) {
            byte bx = x.array[x.offset + i];
            byte by = y.array[y.offset + i];
            if (bx < by) {
                return -1;
            }
            if (bx > by) {
                return 1;
            }
            if (bx == 0) break;
        }
        return 0;
    }

    public static int strcmp(BytePtr x, BytePtr y) {
        return Stdlib.strncmp(x, y, Integer.MAX_VALUE);
    }

    public static BytePtr strcpy(BytePtr destination, BytePtr source) {
        int length2 = source.nullTerminatedStringLength();
        System.arraycopy(source.array, source.offset, destination.array, destination.offset, length2 + 1);
        return destination;
    }

    public static BytePtr strncpy(BytePtr destination, BytePtr source, int num) {
        int di = destination.offset;
        int si = source.offset;
        while (num > 0) {
            byte srcChar = source.array[si++];
            destination.array[di++] = srcChar;
            --num;
            if (srcChar != 0) continue;
            break;
        }
        while (num > 0) {
            destination.array[di++] = 0;
            --num;
        }
        return destination;
    }

    public static int atoi(BytePtr str) {
        try {
            return Integer.parseInt(str.nullTerminatedString());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int strlen(BytePtr x) {
        return x.nullTerminatedStringLength();
    }

    public static BytePtr strcat(BytePtr dest, BytePtr src) {
        int start = dest.offset;
        while (dest.array[start] != 0) {
            ++start;
        }
        int srcLen = Stdlib.strlen(src);
        System.arraycopy(src.array, src.offset, dest.array, start, srcLen);
        dest.array[start + srcLen] = 0;
        return dest;
    }

    public static int printf(BytePtr format2, Object ... arguments) {
        String outputString;
        try {
            outputString = Stdlib.doFormat(format2, arguments);
        }
        catch (Exception e) {
            return -1;
        }
        System.out.print(outputString);
        return outputString.length();
    }

    public static int puts(BytePtr string) {
        System.out.print(string.nullTerminatedString());
        return 0;
    }

    public static int sprintf(BytePtr string, BytePtr format2, Object ... arguments) {
        return Stdlib.snprintf(string, Integer.MAX_VALUE, format2, arguments);
    }

    public static int snprintf(BytePtr string, int limit, BytePtr format2, Object ... arguments) {
        String outputString;
        try {
            outputString = Stdlib.doFormat(format2, arguments);
        }
        catch (Exception e) {
            return -1;
        }
        byte[] outputBytes = outputString.getBytes();
        int bytesToCopy = Math.min(outputBytes.length, limit - 1);
        if (bytesToCopy > 0) {
            System.arraycopy(outputBytes, 0, string.array, string.offset, bytesToCopy);
            string.array[string.offset + bytesToCopy] = 0;
        }
        return outputBytes.length;
    }

    public static int sscanf(BytePtr format2, Object ... arguments) {
        throw new UnsupportedOperationException("TODO: implement " + Stdlib.class.getName() + ".sscanf");
    }

    private static String doFormat(BytePtr format2, Object[] arguments) {
        Object[] convertedArgs = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            convertedArgs[i] = Stdlib.convertFormatArg(arguments[i]);
        }
        return String.format(format2.nullTerminatedString(), convertedArgs);
    }

    private static Object convertFormatArg(Object argument) {
        if (argument instanceof BytePtr) {
            return ((BytePtr)argument).nullTerminatedString();
        }
        return argument;
    }

    @Deprecated
    public static void qsort(Ptr base, int nitems, int size, MethodHandle comparator) {
        throw new UnsupportedOperationException();
    }

    public static void qsort(Object base, int nitems, int size, MethodHandle comparator) {
        throw new UnsupportedOperationException();
    }

    public static ObjectPtr<CharPtr> __ctype_b_loc() {
        return CharTypes.TABLE_PTR;
    }

    @Struct
    public static int[] div(int numer, int denom) {
        int quot = numer / denom;
        int rem = numer % denom;
        return new int[]{quot, rem};
    }

    public static int time(IntPtr seconds) {
        int time2 = (int)(System.currentTimeMillis() / 1000L);
        if (seconds.array != null) {
            seconds.array[seconds.offset] = time2;
        }
        return time2;
    }

    public static tm localtime(IntPtr time2) {
        return new tm(time2.unwrap());
    }

    public static void tzset() {
        TimeZone currentTimezone = TimeZone.getDefault();
        tzname = BytePtr.nullTerminatedString(currentTimezone.getDisplayName(), StandardCharsets.US_ASCII);
        timezone = currentTimezone.getOffset(System.currentTimeMillis());
        daylight = currentTimezone.inDaylightTime(new Date()) ? 1 : 0;
    }

    public static void fflush(Object file2) {
    }

    public static int clock() {
        long millisSinceProgramStart = System.currentTimeMillis() - PROGRAM_START;
        int secondsSinceProgramStart = (int)TimeUnit.MILLISECONDS.toSeconds(millisSinceProgramStart);
        return secondsSinceProgramStart * 4;
    }

    public static int clock_gettime(int clockId, timespec tp) {
        switch (clockId) {
            case 0: 
            case 5: {
                tp.set(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                return 0;
            }
            case 1: {
                tp.set(System.nanoTime(), TimeUnit.NANOSECONDS);
                return 0;
            }
        }
        return -1;
    }

    public static Object fopen() {
        throw new UnsupportedOperationException("fopen() not implemented");
    }

    public static int __isinf(double x) {
        return Double.isInfinite(x) ? 1 : 0;
    }
}

