/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics;

import org.renjin.graphics.Color;
import org.renjin.graphics.GraphicParameters;
import org.renjin.graphics.GraphicsDeviceDriver;
import org.renjin.graphics.OuterMarginUnits;
import org.renjin.graphics.UserWindow;
import org.renjin.graphics.geom.Dimension;
import org.renjin.graphics.geom.Margins;
import org.renjin.graphics.geom.Point;
import org.renjin.graphics.geom.Rectangle;

public final class GraphicsDevice {
    private GraphicsDeviceDriver driver;
    private GraphicParameters parameters = new GraphicParameters();
    private GraphicParameters savedParameters = null;
    private Rectangle innerRegion;
    private Rectangle figureRegion = Rectangle.UNIT_RECT;
    private Margins innerMargins = new Margins(5.1, 4.1, 4.1, 2.1);
    private Rectangle plotRegion;
    private Margins outerMargins = new Margins(0.0, 0.0, 0.0, 0.0);
    private OuterMarginUnits units = OuterMarginUnits.LINES;
    private double scale = 1.0;
    private UserWindow userWindow = new UserWindow();

    public GraphicsDevice(GraphicsDeviceDriver driver) {
        this.driver = driver;
        Dimension inchesPerPixel = driver.getInchesPerPixel();
    }

    private Dimension getLineSize() {
        double lineHeight = this.driver.getCharacterSize().getHeight() * this.scale * this.parameters.getCexBase() * this.parameters.getMex();
        return new Dimension(lineHeight * this.driver.getInchesPerPixel().getAspectRatio(), lineHeight);
    }

    public Dimension getDefaultCharacterSize() {
        return new Dimension(this.driver.getCharacterSize().getWidth() * this.scale, this.driver.getCharacterSize().getHeight() * this.scale);
    }

    public GraphicParameters getParameters() {
        return this.parameters;
    }

    public final void saveParameters() {
        this.savedParameters = this.parameters.clone();
    }

    public final void restoreParameters() {
        if (this.savedParameters == null) {
            throw new IllegalStateException("saveParameters() has not previously been called");
        }
        this.parameters = this.savedParameters;
    }

    public Rectangle getFigureRegion() {
        return this.figureRegion;
    }

    public void setFigureRegion(Rectangle figureCoordinates) {
        this.figureRegion = figureCoordinates;
    }

    public Rectangle getPlotRegion() {
        return this.getFigureRect().normalize(this.getPlotRegionRect());
    }

    private Rectangle getPlotRegionRect() {
        Rectangle figureInDevice = this.getFigureRect();
        Margins innerMarginsInDeviceUnits = this.innerMargins.multiplyBy(this.getLineSize());
        Rectangle plotRegionInDeviceUnits = figureInDevice.apply(innerMarginsInDeviceUnits);
        return plotRegionInDeviceUnits;
    }

    private Rectangle getFigureRect() {
        return this.driver.getDeviceRegion().denormalize(this.getFigureRegion());
    }

    public Dimension getPlotDimensions() {
        Rectangle plotRegionInDeviceUnits = this.getPlotRegionRect();
        return plotRegionInDeviceUnits.size().multiplyBy(this.driver.getInchesPerPixel());
    }

    public Point userToDevice(Point point) {
        return this.getPlotRegionRect().denormalize(this.userWindow.normalize(point));
    }

    public Rectangle userToDevice(Rectangle rectangle) {
        return this.getPlotRegionRect().denormalize(this.userWindow.normalize(rectangle));
    }

    public void setPlotRegion(Rectangle plotRegion) {
        this.plotRegion = this.driver.getDeviceRegion().denormalize(plotRegion);
    }

    public Rectangle getUserCoordinates() {
        return this.userWindow.getUserCoordinates();
    }

    public void setUserCoordinates(Rectangle coords) {
        this.userWindow.setUserCoordinates(coords);
    }

    public void setUserLimits(Rectangle limits) {
        this.userWindow.setLimits(limits, this.parameters);
    }

    public Margins getInnerMargins() {
        return this.innerMargins;
    }

    public void setInnerMargins(Margins innerMargins) {
        this.innerMargins = innerMargins;
    }

    public void drawRectangle(Rectangle bounds, Color fillColor, Color borderColor) {
        this.driver.drawRectangle(this.userToDevice(bounds), fillColor, borderColor, this.parameters);
    }

    public Margins getOuterMargins() {
        return this.outerMargins;
    }

    public void setOuterMargins(Margins outerMargins) {
        this.outerMargins = outerMargins;
    }

    public Dimension getDeviceSizeInInches() {
        return this.driver.getDeviceRegion().size().multiplyBy(this.driver.getInchesPerPixel());
    }

    public void text(Point anchor, double where, String text, Point center, double rotation) {
    }
}

