/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Materialize;
import org.renjin.parser.StringLiterals;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.Indexes;
import org.renjin.primitives.Types;
import org.renjin.primitives.print.ComplexPrinter;
import org.renjin.primitives.print.IntPrinter;
import org.renjin.primitives.print.LogicalPrinter;
import org.renjin.primitives.print.RawPrinter;
import org.renjin.primitives.print.RealPrinter;
import org.renjin.primitives.print.StringPrinter;
import org.renjin.primitives.vector.RowNamesVector;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Print {
    private Print() {
    }

    @Internal(value="print.default")
    @Materialize
    public static SEXP printDefault(@Current Context context, SEXP expression2, SEXP digits, boolean quote, SEXP naPrint, SEXP printGap, SEXP right, SEXP max2, SEXP useSource, SEXP noOp, boolean useS4) throws IOException {
        if (useS4 && Types.isS4(expression2)) {
            Print.printS4(context, expression2);
        } else {
            expression2 = context.materialize(expression2);
            PrintingVisitor visitor = new PrintingVisitor(context).setCharactersPerLine(80).setQuote(quote);
            expression2.accept(visitor);
            context.getSession().getStdOut().print(visitor.getResult());
        }
        context.getSession().getStdOut().flush();
        context.setInvisibleFlag();
        return expression2;
    }

    private static void printS4(Context context, SEXP expression2) {
        context.evaluate(FunctionCall.newCall(Symbol.get("show"), expression2));
    }

    public static String doPrint(SEXP expression2) {
        PrintingVisitor visitor = new PrintingVisitor(null).setCharactersPerLine(80);
        expression2.accept(visitor);
        return visitor.getResult();
    }

    @Generic
    @Internal(value="print.function")
    public static void printFunction(@Current Context context, SEXP x, boolean useSource, @ArgumentList ListVector extraArguments) throws IOException {
        context.getSession().getStdOut().println(x.toString());
        context.getSession().getStdOut().flush();
    }

    static class PrintingVisitor
    extends SexpVisitor<String> {
        private StringBuilder out = new StringBuilder();
        private int charactersPerLine = 80;
        private boolean quote = true;
        private Context context;

        PrintingVisitor(Context context) {
            this.context = context;
        }

        public PrintingVisitor() {
        }

        public PrintingVisitor setCharactersPerLine(int charactersPerLine) {
            this.charactersPerLine = charactersPerLine;
            return this;
        }

        public PrintingVisitor setQuote(boolean quote) {
            this.quote = quote;
            return this;
        }

        public String print(SEXP exp2) {
            exp2.accept(this);
            return this.getResult();
        }

        @Override
        public void visit(ListVector list2) {
            int index = 1;
            for (int i = 0; i != list2.length(); ++i) {
                SEXP value = list2.get(i);
                String name = list2.getName(i);
                if (StringVector.isNA(name)) {
                    this.out.append("[[").append(index).append("]]\n");
                } else {
                    this.out.append("$").append(name).append("\n");
                }
                value.accept(this);
                this.out.append("\n");
                ++index;
            }
            this.printAttributes(list2);
        }

        @Override
        public void visit(FunctionCall call2) {
            this.out.append(Deparse.deparseExp(this.context, call2));
            this.out.append("\n");
        }

        @Override
        protected void unhandled(SEXP exp2) {
            this.out.append(exp2.toString()).append('\n');
            this.printAttributes(exp2);
        }

        @Override
        public String getResult() {
            return this.out.toString();
        }

        @Override
        public void visit(IntVector vector2) {
            this.printVector(vector2, Alignment.RIGHT, new IntPrinter(), "integer");
        }

        @Override
        public void visit(LogicalVector vector2) {
            this.printVector(vector2, Alignment.RIGHT, new LogicalPrinter(), "logical");
        }

        @Override
        public void visit(DoubleVector vector2) {
            this.printVector(vector2, Alignment.RIGHT, new RealPrinter(), "numeric");
        }

        @Override
        public void visit(StringVector vector2) {
            this.printVector(vector2, Alignment.LEFT, new StringPrinter().withQuotes(this.quote), "character");
        }

        @Override
        public void visit(ComplexVector vector2) {
            this.printVector(vector2, Alignment.RIGHT, new ComplexPrinter(), "complex");
        }

        @Override
        public void visit(RawVector vector2) {
            this.printVector(vector2, Alignment.RIGHT, new RawPrinter(), "raw");
        }

        @Override
        public void visit(Null nullExpression) {
            this.out.append("NULL\n");
        }

        @Override
        public void visitSpecial(SpecialFunction special) {
            this.out.append(".Builtin(").append(StringLiterals.format(special.getName(), "NA"));
        }

        @Override
        public <T> void visit(ExternalPtr sexp2) {
            Object instance = sexp2.getInstance();
            if (instance == null) {
                this.out.append("<pointer: null>");
            } else {
                this.out.append(String.format("<pointer: %s@%x", instance.getClass().getName(), System.identityHashCode(instance)));
            }
        }

        private <T> void printVector(Iterable<T> vector2, Alignment align, Function<T, String> printer, String typeName) {
            SEXP sexp2 = (SEXP)((Object)vector2);
            if (sexp2.length() == 0) {
                this.out.append(typeName).append("(0)\n");
            } else {
                ArrayList<String> elements = Lists.newArrayList(Iterables.transform(vector2, printer));
                SEXP dim2 = sexp2.getAttribute(Symbols.DIM);
                if (dim2.length() == 2) {
                    new MatrixPrinter(elements, align, sexp2.getAttributes());
                } else {
                    new VectorPrinter(elements, align, sexp2.getAttributes());
                }
                this.printAttributes(sexp2);
            }
        }

        private void printAttributes(SEXP sexp2) {
            for (PairList.Node node : sexp2.getAttributes().nodes()) {
                if (node.getTag().equals(Symbols.NAMES) || node.getTag().equals(Symbols.DIM) || node.getTag().equals(Symbols.DIMNAMES) || node.getValue() == Null.INSTANCE) continue;
                this.out.append("attr(," + new StringPrinter().apply(node.getName()) + ")\n");
                node.getValue().accept(this);
            }
        }

        private class MatrixPrinter {
            private List<String> elements;
            private final Alignment elementAlign;
            private int colWidth;
            private int maxRowHeaderWidth;
            private int rows;
            private int cols;
            private Vector rowNames = Null.INSTANCE;
            private Vector colNames = Null.INSTANCE;

            private MatrixPrinter(List<String> elements, Alignment elementAlign, AttributeMap attributes2) {
                this.elements = elements;
                this.elementAlign = elementAlign;
                Vector dim2 = (Vector)attributes2.get(Symbols.DIM);
                this.rows = dim2.getElementAsInt(0);
                this.cols = dim2.getElementAsInt(1);
                Vector dimnames2 = (Vector)attributes2.get(Symbols.DIMNAMES);
                if (dimnames2.length() == 2) {
                    this.rowNames = this.unpackRowNames((Vector)dimnames2.getElementAsSEXP(0));
                    this.colNames = (Vector)dimnames2.getElementAsSEXP(1);
                }
                this.calcMaxRowHeaderWidth();
                this.calcColumnWidth();
                this.print();
            }

            private Vector unpackRowNames(Vector rowNames) {
                if (RowNamesVector.isOldCompactForm(rowNames)) {
                    return RowNamesVector.fromOldCompactForm(rowNames);
                }
                return rowNames;
            }

            private String colHeader(int col2) {
                if (this.colNames == Null.INSTANCE) {
                    return "[," + (col2 + 1) + "]";
                }
                return this.naToString(this.colNames.getElementAsString(col2));
            }

            private String rowHeader(int row2) {
                if (this.rowNames == Null.INSTANCE) {
                    return "[" + (row2 + 1) + ",]";
                }
                return this.naToString(this.rowNames.getElementAsString(row2));
            }

            private String naToString(String x) {
                if (x == null) {
                    return "NA";
                }
                return x;
            }

            private void calcMaxRowHeaderWidth() {
                for (int i = 0; i != this.rows; ++i) {
                    int headerLength = this.rowHeader(i).length();
                    if (headerLength <= this.maxRowHeaderWidth) continue;
                    this.maxRowHeaderWidth = headerLength;
                }
            }

            private void calcColumnWidth() {
                for (int i = 0; i != this.cols; ++i) {
                    int headerLength = this.colHeader(i).length();
                    if (headerLength <= this.colWidth) continue;
                    this.colWidth = headerLength;
                }
                for (String element : this.elements) {
                    if (element.length() <= this.colWidth) continue;
                    this.colWidth = element.length();
                }
            }

            private void print() {
                this.printColumnHeaders();
                for (int i = 0; i != this.rows; ++i) {
                    this.appendAligned(this.rowHeader(i), this.maxRowHeaderWidth, Alignment.RIGHT);
                    for (int j = 0; j != this.cols; ++j) {
                        PrintingVisitor.this.out.append(' ');
                        this.appendAligned(this.elements.get(Indexes.matrixIndexToVectorIndex(i, j, this.rows, this.cols)), this.colWidth, this.elementAlign);
                    }
                    PrintingVisitor.this.out.append('\n');
                }
            }

            private void printColumnHeaders() {
                for (int i = 0; i != this.maxRowHeaderWidth; ++i) {
                    PrintingVisitor.this.out.append(' ');
                }
                for (int j = 0; j != this.cols; ++j) {
                    PrintingVisitor.this.out.append(' ');
                    this.appendAligned(this.colHeader(j), this.colWidth, this.elementAlign);
                }
                PrintingVisitor.this.out.append('\n');
            }

            private void appendAligned(String s, int size, Alignment alignment) {
                if (alignment == Alignment.LEFT) {
                    PrintingVisitor.this.out.append(s);
                }
                for (int i = s.length(); i < size; ++i) {
                    PrintingVisitor.this.out.append(' ');
                }
                if (alignment == Alignment.RIGHT) {
                    PrintingVisitor.this.out.append(s);
                }
            }
        }

        private class VectorPrinter {
            private List<String> elements;
            private final Alignment elementAlign;
            private int maxElementWidth;
            private int maxIndexWidth;
            private int elementsPerLine;
            private AtomicVector names;

            private VectorPrinter(List<String> elements, Alignment elementAlign, AttributeMap attributes2) {
                this.elements = elements;
                this.elementAlign = elementAlign;
                this.names = attributes2.getNamesOrNull();
                if (this.hasNames()) {
                    elementAlign = Alignment.RIGHT;
                }
                this.calcMaxElementWidth();
                this.calcMaxIndexWidth();
                this.calcElementsPerLine();
                this.print();
            }

            private boolean hasNames() {
                return this.names != Null.INSTANCE;
            }

            private void calcMaxElementWidth() {
                for (String s : this.elements) {
                    if (s.length() <= this.maxElementWidth) continue;
                    this.maxElementWidth = s.length();
                }
                if (this.hasNames()) {
                    for (int i = 0; i != this.elements.size(); ++i) {
                        int nameLength = this.name(i).length();
                        if (nameLength <= this.maxElementWidth) continue;
                        this.maxElementWidth = nameLength;
                    }
                }
            }

            private void calcMaxIndexWidth() {
                this.maxIndexWidth = (int)Math.ceil(Math.log10(this.elements.size()));
            }

            private int rowHeaderWidth() {
                if (this.hasNames()) {
                    return 0;
                }
                return this.maxIndexWidth + 2;
            }

            private void calcElementsPerLine() {
                this.elementsPerLine = (PrintingVisitor.this.charactersPerLine - this.rowHeaderWidth()) / (this.maxElementWidth + 1);
                if (this.elementsPerLine < 1) {
                    this.elementsPerLine = 1;
                }
            }

            private void print() {
                for (int index = 0; index < this.elements.size(); index += this.elementsPerLine) {
                    if (this.hasNames()) {
                        this.printNames(index);
                    } else {
                        this.printIndex(index);
                    }
                    this.printRow(index);
                }
            }

            private void printIndex(int index) {
                this.appendAligned(String.format("[%d] ", index + 1), this.maxIndexWidth + 2, Alignment.RIGHT);
            }

            private void printNames(int startIndex) {
                for (int i = 0; i != this.elementsPerLine && startIndex + i < this.elements.size(); ++i) {
                    if (i > 0) {
                        PrintingVisitor.this.out.append(' ');
                    }
                    this.appendAligned(this.name(startIndex + i), this.maxElementWidth, this.elementAlign);
                }
                PrintingVisitor.this.out.append("\n");
            }

            private String name(int index) {
                StringVector nameVector = (StringVector)this.names;
                if (nameVector.isElementNA(index)) {
                    return "<NA>";
                }
                return nameVector.getElementAsString(index);
            }

            private void printRow(int startIndex) {
                for (int i = 0; i != this.elementsPerLine && startIndex + i < this.elements.size(); ++i) {
                    if (i > 0) {
                        PrintingVisitor.this.out.append(' ');
                    }
                    this.appendAligned(this.elements.get(startIndex + i), this.maxElementWidth, this.elementAlign);
                }
                PrintingVisitor.this.out.append('\n');
            }

            private void appendAligned(String s, int size, Alignment alignment) {
                if (alignment == Alignment.LEFT) {
                    PrintingVisitor.this.out.append(s);
                }
                for (int i = s.length(); i < size; ++i) {
                    PrintingVisitor.this.out.append(' ');
                }
                if (alignment == Alignment.RIGHT) {
                    PrintingVisitor.this.out.append(s);
                }
            }
        }

        private static enum Alignment {
            LEFT,
            RIGHT;

        }
    }
}

