/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.io.IOException;
import org.renjin.eval.Context;
import org.renjin.eval.Options;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.Conditions;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Warning {
    public static final Symbol LAST_WARNING = Symbol.get("last.warning");

    public static void invokeWarning(@Current Context context, String message, Object ... args2) {
        Warning.emitWarning(context, null, false, String.format(message, args2));
    }

    public static void invokeWarning(@Current Context context, FunctionCall call2, String message, Object ... args2) {
        Warning.emitWarning(context, call2, false, String.format(message, args2));
    }

    @Internal
    public static void warning(@Current Context context, boolean call2, boolean immediate, String message) throws IOException {
        if (call2 || !immediate) {
            FunctionCall currentCall = Warning.findCurrentCall(context, 1);
            Warning.emitWarning(context, currentCall, immediate, message);
        } else {
            context.getSession().getStdOut().println("Warning message:");
            context.getSession().getStdOut().println(message);
        }
    }

    private static FunctionCall findCurrentCall(Context context, int toSkip) {
        while (!context.isTopLevel()) {
            if (context.getCall() != null) {
                if (toSkip == 0) {
                    return context.getCall();
                }
                --toSkip;
            }
            context = context.getParent();
        }
        return null;
    }

    public static void emitWarning(Context context, boolean immediate, String message) {
        Warning.emitWarning(context, Warning.findCurrentCall(context, 0), immediate, message);
    }

    public static void emitWarning(Context context, FunctionCall call2, boolean immediate, String message) {
        ListVector.NamedBuilder condition = new ListVector.NamedBuilder();
        condition.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector("simpleWarning", "warning", "condition"));
        condition.add("message", message);
        if (call2 != null) {
            condition.add("call", (SEXP)call2);
        }
        Conditions.signalCondition(context, condition.build(), message, call2);
        Warning.uncaughtWarning(context, call2, immediate, message);
    }

    private static void uncaughtWarning(Context context, FunctionCall call2, boolean immediate, String message) {
        int warnMode = context.getSession().getSingleton(Options.class).getInt("warn", 0);
        if (warnMode == 1 || warnMode <= 0 && immediate) {
            context.getSession().getStdOut().println("Warning in " + call2.toString() + " :");
            context.getSession().getStdOut().println("  " + message);
        } else if (warnMode == 0) {
            ListVector.NamedBuilder lastWarning = new ListVector.NamedBuilder();
            Environment baseEnv = context.getBaseEnvironment();
            if (baseEnv.hasVariable(LAST_WARNING)) {
                lastWarning.addAll((ListVector)baseEnv.getVariable(LAST_WARNING).force(context));
            }
            if (call2 != null) {
                lastWarning.add(message, (SEXP)call2);
            } else {
                lastWarning.add(message, (SEXP)Null.INSTANCE);
            }
            baseEnv.setVariable(LAST_WARNING, (SEXP)lastWarning.build());
        }
    }

    @Internal
    public static void printDeferredWarnings(@Current Context context) {
        context.getSession().getConnectionTable().getStderr().getPrintWriter().println("In addition: (TODO)");
    }
}

