/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.matrix;

import org.renjin.primitives.vector.AttributeDecoratingVector;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class DeferredRowMeans
extends DoubleVector
implements MemoizedComputation {
    private final AtomicVector vector;
    private int numRows;
    private int numCols;
    private double[] means;

    public DeferredRowMeans(AtomicVector vector2, int numRows, AttributeMap attributes2) {
        super(attributes2);
        this.vector = vector2;
        this.numRows = numRows;
        this.numCols = vector2.length() / numRows;
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.vector, new IntArrayVector(this.numRows)};
    }

    @Override
    public String getComputationName() {
        return "rowMeans";
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new AttributeDecoratingVector(this, attributes2);
    }

    @Override
    public double getElementAsDouble(int index) {
        if (this.means == null) {
            this.computeMeans();
        }
        return this.means[index];
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    @Override
    public int length() {
        return this.numRows;
    }

    private void computeMeans() {
        int i;
        System.err.println("EEK! rowMeans.calculate() called directly");
        double[] means = new double[this.numRows];
        int row2 = 0;
        for (i = 0; i != this.vector.length(); ++i) {
            int n = row2++;
            means[n] = means[n] + this.vector.getElementAsDouble(i);
            if (row2 != this.numRows) continue;
            row2 = 0;
        }
        i = 0;
        while (i != this.numRows) {
            int n = i++;
            means[n] = means[n] / (double)this.numCols;
        }
        this.means = means;
    }

    @Override
    public boolean isCalculated() {
        return this.means != null;
    }

    @Override
    public boolean isDeferred() {
        return !this.isCalculated();
    }

    @Override
    public Vector forceResult() {
        if (this.means == null) {
            this.computeMeans();
        }
        return DoubleArrayVector.unsafe(this.means);
    }

    @Override
    public void setResult(Vector result) {
        this.means = ((DoubleArrayVector)result).toDoubleArrayUnsafe();
    }
}

