/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.eval.Context;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Recursive;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;

public class Promise
extends AbstractSEXP
implements Recursive {
    public static final String TYPE_NAME = "promise";
    protected Environment environment;
    protected SEXP expression;
    private SEXP result;
    private boolean missingArgument;

    protected Promise(Environment environment2, SEXP expression2) {
        assert (environment2 != null);
        this.expression = expression2;
        this.environment = environment2;
    }

    public Promise(SEXP expression2, SEXP result) {
        this.environment = Environment.EMPTY;
        this.expression = expression2;
        this.result = result;
    }

    @Override
    public SEXP force(Context context) {
        if (this.result == null) {
            this.result = this.doEval(context);
        }
        return this.result;
    }

    protected SEXP doEval(Context context) {
        return context.evaluate(this.expression, this.environment);
    }

    public void setResult(SEXP exp2) {
        this.result = exp2;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    public SEXP getExpression() {
        return this.expression;
    }

    public String toString() {
        return "{" + this.expression + "=>" + this.result + "}";
    }

    public static Promise repromise(SEXP value) {
        return new Promise(value, value);
    }

    public boolean isMissingArgument() {
        return this.missingArgument;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public SEXP getValue() {
        return this.result;
    }

    public boolean isEvaluated() {
        return this.result != null;
    }

    public static Promise promiseMissing(Environment environment2, SEXP defaultValue) {
        Promise promise = new Promise(environment2, defaultValue);
        promise.missingArgument = true;
        return promise;
    }

    public static Promise repromise(Environment environment2, SEXP expression2) {
        if (expression2 instanceof Promise) {
            return (Promise)expression2;
        }
        return new Promise(environment2, expression2);
    }
}

