/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.Attributes;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.models.Formula;
import org.renjin.stats.internals.models.FormulaInterpreter;
import org.renjin.stats.internals.models.ModelMatrixBuilder;

public class Models {
    @Internal(value="terms.formula")
    public static SEXP termsFormula(@Current Context context, FunctionCall x, SEXP specials, SEXP data, boolean keepOrder, boolean allowDotAsName) {
        Formula formula2 = new FormulaInterpreter().withData(data).allowDotAsName(allowDotAsName).interpret(x);
        AttributeMap.Builder attributes2 = AttributeMap.builder();
        attributes2.set("variables", (SEXP)formula2.buildVariablesAttribute());
        attributes2.set("factors", formula2.buildFactorsMatrix());
        attributes2.set("term.labels", (SEXP)formula2.buildTermLabels());
        attributes2.set("order", formula2.buildInteractionOrderAttribute());
        attributes2.set("intercept", (SEXP)formula2.buildInterceptAttribute());
        attributes2.set("response", (SEXP)formula2.buildResponseAttribute());
        attributes2.set(".Environment", (SEXP)context.getGlobalEnvironment());
        attributes2.set("class", (SEXP)new StringArrayVector("terms", "formula"));
        if (specials != Null.INSTANCE) {
            attributes2.set("specials", (SEXP)Models.buildSpecials((AtomicVector)specials));
        }
        return formula2.getExpandedFormula().setAttributes(attributes2);
    }

    private static PairList buildSpecials(AtomicVector specials) {
        PairList.Builder pairList = new PairList.Builder();
        for (int i = 0; i != specials.length(); ++i) {
            pairList.add(Symbol.get(specials.getElementAsString(i)), (SEXP)Null.INSTANCE);
        }
        return pairList.build();
    }

    public static int nrows(SEXP s) {
        if (s instanceof Vector) {
            SEXP dim2 = s.getAttribute(Symbols.DIM);
            if (dim2 == Null.INSTANCE) {
                return s.length();
            }
            return ((IntVector)dim2).getElementAsInt(0);
        }
        if (Attributes.inherits(s, "data.frame")) {
            return Models.nrows(s.getElementAsSEXP(0));
        }
        throw new EvalException("object is not a matrix", new Object[0]);
    }

    @Internal(value="model.matrix")
    public static Vector modelMatrix(@Current Context context, FunctionCall terms2, ListVector modelFrame) {
        return ModelMatrixBuilder.build(context, terms2, modelFrame);
    }
}

