/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAssignment;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBreak;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JContinue;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDoLoop;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JLabel;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JReturn;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JThrow;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.JWhileLoop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBlock
implements JGenerable,
JStatement {
    private final List<Object> content = new ArrayList<Object>();
    private boolean bracesRequired = true;
    private boolean indentRequired = true;
    private int pos;

    public JBlock() {
        this(true, true);
    }

    public JBlock(boolean bracesRequired, boolean indentRequired) {
        this.bracesRequired = bracesRequired;
        this.indentRequired = indentRequired;
    }

    public List<Object> getContents() {
        return Collections.unmodifiableList(this.content);
    }

    private <T> T insert(T statementOrDeclaration) {
        this.content.add(this.pos, statementOrDeclaration);
        ++this.pos;
        return statementOrDeclaration;
    }

    public int pos() {
        return this.pos;
    }

    public int pos(int newPos) {
        int r = this.pos;
        if (newPos > this.content.size() || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
        return r;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public JVar decl(JType type, String name) {
        return this.decl(0, type, name, null);
    }

    public JVar decl(JType type, String name, JExpression init) {
        return this.decl(0, type, name, init);
    }

    public JVar decl(int mods, JType type, String name, JExpression init) {
        JVar v = new JVar(JMods.forVar(mods), type, name, init);
        this.insert(v);
        this.bracesRequired = true;
        this.indentRequired = true;
        return v;
    }

    public JBlock assign(JAssignmentTarget lhs, JExpression exp2) {
        this.insert(new JAssignment(lhs, exp2));
        return this;
    }

    public JBlock assignPlus(JAssignmentTarget lhs, JExpression exp2) {
        this.insert(new JAssignment(lhs, exp2, "+"));
        return this;
    }

    public JInvocation invoke(JExpression expr, String method) {
        JInvocation i = new JInvocation(expr, method);
        this.insert(i);
        return i;
    }

    public JInvocation invoke(JExpression expr, JMethod method) {
        return this.insert(new JInvocation(expr, method));
    }

    public JInvocation staticInvoke(JClass type, String method) {
        return this.insert(new JInvocation(type, method));
    }

    public JInvocation invoke(String method) {
        return this.insert(new JInvocation((JExpression)null, method));
    }

    public JInvocation invoke(JMethod method) {
        return this.insert(new JInvocation((JExpression)null, method));
    }

    public JBlock add(JStatement s) {
        this.insert(s);
        return this;
    }

    public JConditional _if(JExpression expr) {
        return this.insert(new JConditional(expr));
    }

    public JForLoop _for() {
        return this.insert(new JForLoop());
    }

    public JWhileLoop _while(JExpression test) {
        return this.insert(new JWhileLoop(test));
    }

    public JSwitch _switch(JExpression test) {
        return this.insert(new JSwitch(test));
    }

    public JDoLoop _do(JExpression test) {
        return this.insert(new JDoLoop(test));
    }

    public JTryBlock _try() {
        return this.insert(new JTryBlock());
    }

    public void _return() {
        this.insert(new JReturn(null));
    }

    public void _return(JExpression exp2) {
        this.insert(new JReturn(exp2));
    }

    public void _throw(JExpression exp2) {
        this.insert(new JThrow(exp2));
    }

    public void _break() {
        this._break(null);
    }

    public void _break(JLabel label) {
        this.insert(new JBreak(label));
    }

    public JLabel label(String name) {
        JLabel l = new JLabel(name);
        this.insert(l);
        return l;
    }

    public void _continue(JLabel label) {
        this.insert(new JContinue(label));
    }

    public void _continue() {
        this._continue(null);
    }

    public JBlock block() {
        JBlock b = new JBlock();
        b.bracesRequired = false;
        b.indentRequired = false;
        return this.insert(b);
    }

    public JStatement directStatement(final String source) {
        JStatement s = new JStatement(){

            public void state(JFormatter f) {
                f.p(source).nl();
            }
        };
        this.add(s);
        return s;
    }

    @Override
    public void generate(JFormatter f) {
        if (this.bracesRequired) {
            f.p('{').nl();
        }
        if (this.indentRequired) {
            f.i();
        }
        this.generateBody(f);
        if (this.indentRequired) {
            f.o();
        }
        if (this.bracesRequired) {
            f.p('}');
        }
    }

    void generateBody(JFormatter f) {
        for (Object o : this.content) {
            if (o instanceof JDeclaration) {
                f.d((JDeclaration)o);
                continue;
            }
            f.s((JStatement)o);
        }
    }

    public JForEach forEach(JType varType, String name, JExpression collection) {
        return this.insert(new JForEach(varType, name, collection));
    }

    @Override
    public void state(JFormatter f) {
        f.g(this);
        if (this.bracesRequired) {
            f.nl();
        }
    }
}

