/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class SingleByteEncoder
extends CharsetEncoder {
    private final short[] index1;
    private final String index2;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected SingleByteEncoder(Charset cs, short[] index1, String index2, int mask1, int mask2, int shift) {
        super(cs, 1.0f, 1.0f);
        this.index1 = index1;
        this.index2 = index2;
        this.mask1 = mask1;
        this.mask2 = mask2;
        this.shift = shift;
    }

    public boolean canEncode(char c2) {
        char testEncode = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
        return testEncode != '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
        int sp;
        char[] sa = src.array();
        byte[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        dp = dp <= dl ? dp : dl;
        try {
            int sl;
            for (sp = (sp = src.arrayOffset() + src.position()) <= (sl = src.arrayOffset() + src.limit()) ? sp : sl; sp < sl; ++sp) {
                char c2 = sa[sp];
                if (Surrogate.is(c2)) {
                    if (this.sgp.parse(c2, sa, sp, sl) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (dl - dp < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char e = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
                if (e == '\u0000' && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                da[dp++] = (byte)e;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
        int mark = src.position();
        try {
            while (src.hasRemaining()) {
                char c2 = src.get();
                if (Surrogate.is(c2)) {
                    if (this.sgp.parse(c2, src) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!dst.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char e = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
                if (e == '\u0000' && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                ++mark;
                dst.put((byte)e);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.encodeArrayLoop(src, dst);
        }
        return this.encodeBufferLoop(src, dst);
    }

    public byte encode(char inputChar) {
        return (byte)this.index2.charAt(this.index1[(inputChar & this.mask1) >> this.shift] + (inputChar & this.mask2));
    }
}

